/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.registry;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModDamageTypes {
    public static ResourceKey<DamageType> INFINITY = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)new ResourceLocation("avaritia", "infinity"));
    public static final RegistrySetBuilder DAMAGE_BUILDER = new RegistrySetBuilder().add(Registries.DAMAGE_TYPE, ModDamageTypes::bootstrap);

    public static HolderLookup.Provider append(HolderLookup.Provider original) {
        return DAMAGE_BUILDER.buildPatch((RegistryAccess)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY), original);
    }

    public static void bootstrap(BootstapContext<DamageType> context) {
        context.register(INFINITY, (Object)new DamageType("infinity", DamageScaling.ALWAYS, 0.1f));
    }

    public static DamageSource causeRandomDamage(Level level, @Nullable Entity itemEntity, @Nullable Entity owner) {
        return new DamageSourceRandomMessages((Holder<DamageType>)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(INFINITY), itemEntity, owner);
    }

    public static DamageSource causeRandomDamage(Level level, @Nullable Entity owner) {
        return new DamageSourceRandomMessages((Holder<DamageType>)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(INFINITY), owner, owner);
    }

    public static class DamageSourceRandomMessages
    extends DamageSource {
        public DamageSourceRandomMessages(Holder<DamageType> damageTypeHolder, @Nullable Entity itemEntity, @Nullable Entity owner) {
            super(damageTypeHolder, itemEntity, owner);
        }

        @NotNull
        public Component getLocalizedDeathMessage(LivingEntity attacked) {
            int type = attacked.getRandom().nextInt(3);
            LivingEntity livingentity = attacked.getKillCredit();
            String s = "death.attack." + this.getMsgId() + "." + type;
            String s1 = "death.attack." + this.getMsgId() + ".player." + type;
            return livingentity != null ? Component.translatable((String)s1, (Object[])new Object[]{attacked.getDisplayName(), livingentity.getDisplayName()}) : Component.translatable((String)s, (Object[])new Object[]{attacked.getDisplayName()});
        }
    }
}

