/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.test;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.util.recipe.RecipeUtils;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.core.singularity.SingularityDataManager;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import java.util.Collection;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SingularityRecipeTestHandler {
    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        SingularityRecipeTestHandler.validateSingularityRecipeSync();
    }

    private static void validateSingularityRecipeSync() {
        Const.LOGGER.info("\u5f00\u59cb\u9a8c\u8bc1\u5947\u70b9\u914d\u65b9\u540c\u6b65\u72b6\u6001...");
        try {
            Collection<Singularity> singularities = SingularityDataManager.getInstance().getSingularities();
            int totalSingularities = singularities.size();
            int enabledSingularities = (int)singularities.stream().filter(s -> !s.isRecipeDisabled()).count();
            Const.LOGGER.info("\u603b\u5947\u70b9\u6570\u91cf: {}, \u542f\u7528\u914d\u65b9\u7684\u5947\u70b9\u6570\u91cf: {}", (Object)totalSingularities, (Object)enabledSingularities);
            RecipeManager recipeManager = RecipeUtils.getRecipeManager();
            if (recipeManager == null) {
                Const.LOGGER.warn("\u65e0\u6cd5\u83b7\u53d6RecipeManager\uff0c\u8df3\u8fc7\u914d\u65b9\u9a8c\u8bc1");
                return;
            }
            Map compressorRecipes = recipeManager.byType((RecipeType)ModRecipeTypes.COMPRESSOR_RECIPE.get());
            int singularityRecipes = 0;
            int matchedRecipes = 0;
            for (Map.Entry entry : compressorRecipes.entrySet()) {
                ResourceLocation recipeId = (ResourceLocation)entry.getKey();
                if (!recipeId.getPath().endsWith("_singularity")) continue;
                ++singularityRecipes;
                String singularityPath = recipeId.getPath().replace("_singularity", "");
                ResourceLocation singularityId = new ResourceLocation(recipeId.getNamespace(), singularityPath);
                if (SingularityDataManager.getInstance().hasSingularity(singularityId)) {
                    ++matchedRecipes;
                    continue;
                }
                Const.LOGGER.warn("\u53d1\u73b0\u5b64\u7acb\u7684\u538b\u7f29\u673a\u914d\u65b9: {}, \u5bf9\u5e94\u7684\u5947\u70b9\u4e0d\u5b58\u5728", (Object)recipeId);
            }
            Const.LOGGER.info("\u538b\u7f29\u673a\u914d\u65b9\u7edf\u8ba1 - \u5947\u70b9\u76f8\u5173\u914d\u65b9: {}, \u5339\u914d\u7684\u914d\u65b9: {}", (Object)singularityRecipes, (Object)matchedRecipes);
            if (enabledSingularities == matchedRecipes) {
                Const.LOGGER.info("\u2705 \u5947\u70b9\u914d\u65b9\u540c\u6b65\u9a8c\u8bc1\u901a\u8fc7! \u6240\u6709\u542f\u7528\u7684\u5947\u70b9\u90fd\u6709\u5bf9\u5e94\u7684\u538b\u7f29\u673a\u914d\u65b9");
            } else {
                Const.LOGGER.error("\u274c \u5947\u70b9\u914d\u65b9\u540c\u6b65\u9a8c\u8bc1\u5931\u8d25! \u542f\u7528\u7684\u5947\u70b9\u6570\u91cf({})\u4e0e\u5339\u914d\u7684\u914d\u65b9\u6570\u91cf({})\u4e0d\u4e00\u81f4", (Object)enabledSingularities, (Object)matchedRecipes);
                for (Singularity singularity : singularities) {
                    if (singularity.isRecipeDisabled()) continue;
                    ResourceLocation expectedRecipeId = new ResourceLocation(singularity.getId().getNamespace(), singularity.getId().getPath() + "_singularity");
                    boolean hasRecipe = compressorRecipes.containsKey(expectedRecipeId);
                    Const.LOGGER.info("\u5947\u70b9: {} -> \u914d\u65b9: {} ({})", (Object)singularity.getId(), (Object)expectedRecipeId, (Object)(hasRecipe ? "\u5b58\u5728" : "\u7f3a\u5931"));
                }
            }
        }
        catch (Exception e) {
            Const.LOGGER.error("\u5947\u70b9\u914d\u65b9\u540c\u6b65\u9a8c\u8bc1\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }
}

