/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.common.entity.EndestPearlEntity;
import committee.nova.mods.avaritia.common.item.misc.InfinityClockItem;
import committee.nova.mods.avaritia.core.singularity.SingularityDataManager;
import committee.nova.mods.avaritia.init.compat.projecte.ModEMCHandler;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.data.ModDataGen;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModCreativeModeTabs;
import committee.nova.mods.avaritia.init.registry.ModEnchants;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModMenus;
import committee.nova.mods.avaritia.init.registry.ModMobEffects;
import committee.nova.mods.avaritia.init.registry.ModParticles;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import net.minecraft.Util;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;

@Mod(value="avaritia")
public class Avaritia {
    public Avaritia() {
        ModConfig.register();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(ModDataGen::gatherData);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.register((Object)this);
        ModBlocks.BLOCKS.register(bus);
        ModItems.ITEMS.register(bus);
        ModCreativeModeTabs.TABS.register(bus);
        ModTileEntities.BLOCK_ENTITIES.register(bus);
        ModMenus.MENUS.register(bus);
        ModMobEffects.MOB_EFFECTS.register(bus);
        ModEntities.ENTITIES.register(bus);
        ModEnchants.ENCHANTMENT.register(bus);
        ModParticles.PARTICLE_TYPE.register(bus);
        ModRecipeTypes.RECIPES.register(bus);
        ModRecipeSerializers.SERIALIZERS.register(bus);
    }

    public void setup(FMLCommonSetupEvent event) {
        if (Const.isLoad("projecte")) {
            ModEMCHandler.init();
        }
        SingularityDataManager.onCommonSetup();
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.endest_pearl.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            @NotNull
            protected Projectile getProjectile(@NotNull Level level, @NotNull Position position, @NotNull ItemStack stack) {
                return (Projectile)Util.make((Object)((Object)new EndestPearlEntity(level, position.x(), position.y(), position.z())), entity -> entity.setItem(stack));
            }
        });
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        ServerLevel overworld = event.getServer().getLevel(Level.OVERWORLD);
        if (overworld != null) {
            InfinityClockItem.loadAcceleratedBlocksFromSavedData(overworld);
        }
    }

    @SubscribeEvent
    public void onLevelSave(LevelEvent.Save event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (level = (ServerLevel)levelAccessor).dimension() == Level.OVERWORLD) {
            InfinityClockItem.saveAcceleratedBlocksToSavedData(level);
        }
    }
}

