/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CachedFormat {
    public static final CachedFormat BLOCK = new CachedFormat(DefaultVertexFormat.BLOCK);
    private static final Map<VertexFormat, CachedFormat> formatCache = new ConcurrentHashMap<VertexFormat, CachedFormat>();
    public final VertexFormat format;
    public final boolean hasPosition;
    public final boolean hasNormal;
    public final boolean hasColor;
    public final boolean hasUV;
    public final boolean hasOverlay;
    public final boolean hasLightMap;
    public final int positionIndex;
    public final int normalIndex;
    public final int colorIndex;
    public final int uvIndex;
    public final int overlayIndex;
    public final int lightMapIndex;
    public final int elementCount;

    private CachedFormat(VertexFormat format) {
        this.format = format;
        ImmutableList elements = format.getElements();
        this.elementCount = elements.size();
        boolean hasPosition = false;
        boolean hasNormal = false;
        boolean hasColor = false;
        boolean hasUV = false;
        boolean hasOverlay = false;
        boolean hasLightMap = false;
        int positionIndex = -1;
        int normalIndex = -1;
        int colorIndex = -1;
        int uvIndex = -1;
        int overlayIndex = -1;
        int lightMapIndex = -1;
        block11: for (int i = 0; i < this.elementCount; ++i) {
            VertexFormatElement element = (VertexFormatElement)elements.get(i);
            block0 : switch (element.getUsage()) {
                case POSITION: {
                    if (hasPosition) {
                        throw new IllegalStateException("Found 2 position elements..");
                    }
                    hasPosition = true;
                    positionIndex = i;
                    continue block11;
                }
                case NORMAL: {
                    if (hasNormal) {
                        throw new IllegalStateException("Found 2 normal elements..");
                    }
                    hasNormal = true;
                    normalIndex = i;
                    continue block11;
                }
                case COLOR: {
                    if (hasColor) {
                        throw new IllegalStateException("Found 2 color elements..");
                    }
                    hasColor = true;
                    colorIndex = i;
                    continue block11;
                }
                case UV: {
                    switch (element.getIndex()) {
                        case 0: {
                            if (hasUV) {
                                throw new IllegalStateException("Found 2 UV elements..");
                            }
                            hasUV = true;
                            uvIndex = i;
                            break block0;
                        }
                        case 1: {
                            if (hasOverlay) {
                                throw new IllegalStateException("Found 2 Overlay elements..");
                            }
                            hasOverlay = true;
                            overlayIndex = i;
                            break block0;
                        }
                        case 2: {
                            if (hasLightMap) {
                                throw new IllegalStateException("Found 2 LightMap elements..");
                            }
                            hasLightMap = true;
                            lightMapIndex = i;
                        }
                    }
                }
            }
        }
        this.hasPosition = hasPosition;
        this.hasNormal = hasNormal;
        this.hasColor = hasColor;
        this.hasUV = hasUV;
        this.hasOverlay = hasOverlay;
        this.hasLightMap = hasLightMap;
        this.positionIndex = positionIndex;
        this.normalIndex = normalIndex;
        this.colorIndex = colorIndex;
        this.uvIndex = uvIndex;
        this.overlayIndex = overlayIndex;
        this.lightMapIndex = lightMapIndex;
    }

    public static CachedFormat lookup(VertexFormat format) {
        if (format == DefaultVertexFormat.BLOCK) {
            return BLOCK;
        }
        return formatCache.computeIfAbsent(format, CachedFormat::new);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CachedFormat)) {
            return false;
        }
        CachedFormat other = (CachedFormat)obj;
        return other.elementCount == this.elementCount && other.positionIndex == this.positionIndex && other.normalIndex == this.normalIndex && other.colorIndex == this.colorIndex && other.uvIndex == this.uvIndex && other.lightMapIndex == this.lightMapIndex;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.elementCount;
        result = 31 * result + this.positionIndex;
        result = 31 * result + this.normalIndex;
        result = 31 * result + this.colorIndex;
        result = 31 * result + this.uvIndex;
        result = 31 * result + this.lightMapIndex;
        return result;
    }
}

