/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.render.buffer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import committee.nova.mods.avaritia.api.client.model.CachedFormat;
import committee.nova.mods.avaritia.api.client.model.Quad;
import committee.nova.mods.avaritia.api.client.render.buffer.ISpriteAwareVertexConsumer;
import committee.nova.mods.avaritia.api.client.util.color.Color;
import committee.nova.mods.avaritia.api.client.util.color.ColorRGBA;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class BakedQuadVertexBuilder
implements VertexConsumer,
ISpriteAwareVertexConsumer {
    private final List<Quad> quadList = new ArrayList<Quad>();
    private final VertexFormat.Mode mode;
    private final int vSize;
    private CachedFormat format;
    private Color defaultColor;
    private Quad current;
    private int vertex;

    public BakedQuadVertexBuilder() {
        this(VertexFormat.Mode.QUADS);
    }

    public BakedQuadVertexBuilder(VertexFormat format) {
        this(format, VertexFormat.Mode.QUADS);
    }

    public BakedQuadVertexBuilder(CachedFormat format) {
        this(format, VertexFormat.Mode.QUADS);
    }

    public BakedQuadVertexBuilder(VertexFormat.Mode mode) {
        this(CachedFormat.BLOCK, mode);
    }

    public BakedQuadVertexBuilder(VertexFormat format, VertexFormat.Mode mode) {
        this(CachedFormat.lookup(format), mode);
    }

    public BakedQuadVertexBuilder(CachedFormat format, VertexFormat.Mode mode) {
        if (mode != VertexFormat.Mode.QUADS && mode != VertexFormat.Mode.TRIANGLES) {
            throw new IllegalArgumentException("Only QUADS or TRIANGLES supported. Got: " + String.valueOf(mode));
        }
        this.mode = mode;
        this.format = format;
        this.vSize = mode.primitiveLength;
    }

    public void setFormat(VertexFormat format) {
        this.setFormat(CachedFormat.lookup(format));
    }

    public void setFormat(CachedFormat format) {
        this.format = format;
    }

    public void reset() {
        this.quadList.clear();
        this.current = null;
        this.vertex = 0;
    }

    @Override
    public void sprite(TextureAtlasSprite sprite) {
        this.checkNewQuad();
        this.current.setTexture(sprite);
    }

    public VertexConsumer vertex(double x, double y, double z) {
        if (!this.format.hasPosition) {
            return this;
        }
        this.checkNewQuad();
        this.current.vertices[this.vertex].vec[0] = (float)x;
        this.current.vertices[this.vertex].vec[1] = (float)y;
        this.current.vertices[this.vertex].vec[2] = (float)z;
        return this;
    }

    public VertexConsumer color(int red, int green, int blue, int alpha) {
        if (!this.format.hasColor) {
            return this;
        }
        this.checkNewQuad();
        this.current.vertices[this.vertex].color[0] = (float)red / 255.0f;
        this.current.vertices[this.vertex].color[1] = (float)green / 255.0f;
        this.current.vertices[this.vertex].color[2] = (float)blue / 255.0f;
        this.current.vertices[this.vertex].color[3] = (float)alpha / 255.0f;
        return this;
    }

    public VertexConsumer uv(float u, float v) {
        if (!this.format.hasUV) {
            return this;
        }
        this.checkNewQuad();
        this.current.vertices[this.vertex].uv[0] = u;
        this.current.vertices[this.vertex].uv[1] = v;
        return this;
    }

    public VertexConsumer overlayCoords(int u, int v) {
        if (!this.format.hasOverlay) {
            return this;
        }
        this.checkNewQuad();
        this.current.vertices[this.vertex].overlay[0] = (float)u / 240.0f;
        this.current.vertices[this.vertex].overlay[1] = (float)v / 240.0f;
        return this;
    }

    public VertexConsumer uv2(int u, int v) {
        if (!this.format.hasLightMap) {
            return this;
        }
        this.checkNewQuad();
        this.current.vertices[this.vertex].lightmap[0] = (float)u / 240.0f;
        this.current.vertices[this.vertex].lightmap[1] = (float)v / 240.0f;
        return this;
    }

    public VertexConsumer normal(float x, float y, float z) {
        if (!this.format.hasNormal) {
            return this;
        }
        this.checkNewQuad();
        this.current.vertices[this.vertex].normal[0] = x;
        this.current.vertices[this.vertex].normal[1] = y;
        this.current.vertices[this.vertex].normal[2] = z;
        return this;
    }

    public void endVertex() {
        ++this.vertex;
        if (this.vertex == this.vSize) {
            if (this.mode == VertexFormat.Mode.TRIANGLES) {
                for (int e = 0; e < this.current.format.elementCount; ++e) {
                    System.arraycopy(this.current.vertices[2].raw[e], 0, this.current.vertices[3].raw[e], 0, 4);
                }
            }
            if (this.current.sprite == null) {
                throw new IllegalStateException("Sprite not set.");
            }
            if (this.defaultColor != null) {
                float[] colour = this.defaultColor.getRGBA();
                for (Quad.Vertex v : this.current.vertices) {
                    System.arraycopy(colour, 0, v.color, 0, 4);
                }
            }
            this.quadList.add(this.current);
            this.current = null;
            this.vertex = 0;
        }
    }

    public void defaultColor(int r, int g, int b, int a) {
        this.defaultColor = new ColorRGBA(r, g, b, a);
    }

    public void unsetDefaultColor() {
        this.defaultColor = null;
    }

    public List<BakedQuad> bake() {
        if (this.current != null) {
            throw new IllegalStateException("Not finished building.");
        }
        return this.quadList.stream().map(Quad::bake).collect(Collectors.toList());
    }

    private void checkNewQuad() {
        if (this.current == null) {
            this.current = new Quad(this.format);
        }
    }
}

