/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.render.buffer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import committee.nova.mods.avaritia.api.client.render.buffer.ISpriteAwareVertexConsumer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.jetbrains.annotations.NotNull;

public abstract class DelegatingVertexConsumer
implements ISpriteAwareVertexConsumer {
    protected final VertexConsumer delegate;

    public DelegatingVertexConsumer(VertexConsumer delegate) {
        this.delegate = delegate;
    }

    @Override
    public void sprite(TextureAtlasSprite sprite) {
        VertexConsumer vertexConsumer = this.delegate;
        if (vertexConsumer instanceof ISpriteAwareVertexConsumer) {
            ISpriteAwareVertexConsumer spriteCons = (ISpriteAwareVertexConsumer)vertexConsumer;
            spriteCons.sprite(sprite);
        }
    }

    @NotNull
    public VertexConsumer vertex(double x, double y, double z) {
        this.delegate.vertex(x, y, z);
        return this;
    }

    @NotNull
    public VertexConsumer color(int r, int g, int b, int a) {
        this.delegate.color(r, g, b, a);
        return this;
    }

    @NotNull
    public VertexConsumer uv(float u, float v) {
        this.delegate.uv(u, v);
        return this;
    }

    @NotNull
    public VertexConsumer overlayCoords(int u, int v) {
        this.delegate.overlayCoords(u, v);
        return this;
    }

    @NotNull
    public VertexConsumer uv2(int u, int v) {
        this.delegate.uv2(u, v);
        return this;
    }

    @NotNull
    public VertexConsumer normal(float x, float y, float z) {
        this.delegate.normal(x, y, z);
        return this;
    }

    public void endVertex() {
        this.delegate.endVertex();
    }

    public void defaultColor(int r, int g, int b, int a) {
        this.delegate.defaultColor(r, g, b, a);
    }

    public void unsetDefaultColor() {
        this.delegate.unsetDefaultColor();
    }
}

