/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.common.tile;

import committee.nova.mods.avaritia.api.util.TileEntityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class BaseTileEntity
extends BlockEntity
implements MenuProvider {
    private boolean isChanged = false;

    public BaseTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::saveWithFullMetadata);
    }

    @NotNull
    public CompoundTag getUpdateTag() {
        return this.saveWithFullMetadata();
    }

    public void setChanged() {
        super.setChanged();
        this.isChanged = true;
    }

    public void setChangedFast() {
        if (this.level != null) {
            this.level.blockEntityChanged(this.getBlockPos());
            this.isChanged = true;
        }
    }

    public void setChangedAndDispatch() {
        this.setChanged();
        TileEntityUtils.dispatchToNearbyPlayers(this);
        this.isChanged = false;
    }

    public void dispatchIfChanged() {
        if (this.isChanged) {
            TileEntityUtils.dispatchToNearbyPlayers(this);
            this.isChanged = false;
        }
    }
}

