/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.util;

import committee.nova.mods.avaritia.init.compat.curios.CuriosTools;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryUtils {
    public static ItemStack tryInsert(ItemStack itemInv, ItemStack stack) {
        AtomicReference<ItemStack> returnStack = new AtomicReference<ItemStack>(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.getCount()));
        itemInv.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> returnStack.set(ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)stack, (boolean)false)));
        return returnStack.get();
    }

    public static ItemStack tryFilteredInsert(ItemStack itemInv, ItemStack stack) {
        if (itemInv.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() && InventoryUtils.itemInvHasItem(itemInv, stack)) {
            return InventoryUtils.tryInsert(itemInv, stack);
        }
        return stack;
    }

    private static boolean itemInvHasItem(ItemStack itemInv, ItemStack stack) {
        AtomicBoolean hasItem = new AtomicBoolean(false);
        itemInv.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                if (h.getStackInSlot(i).getItem() != stack.getItem()) continue;
                hasItem.set(true);
            }
        });
        return hasItem.get();
    }

    public static ItemStack findFirstItem(Player player, Item consumeFrom) {
        return player.getInventory().items.stream().filter(s -> !s.isEmpty() && s.getItem() == consumeFrom).findFirst().orElse(ItemStack.EMPTY);
    }

    public static int getFirstSlotWithStack(ItemStack itemInv, ItemStack stack) {
        AtomicInteger slot = new AtomicInteger(-1);
        itemInv.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                if (h.getStackInSlot(i).getItem() != stack.getItem()) continue;
                slot.set(i);
            }
        });
        return slot.get();
    }

    private static int getLastSlotWithStack(ItemStack itemInv, ItemStack stack) {
        AtomicInteger slot = new AtomicInteger(-1);
        itemInv.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            for (int i = h.getSlots() - 1; i >= 0; --i) {
                if (h.getStackInSlot(i).getItem() != stack.getItem()) continue;
                slot.set(i);
            }
        });
        return slot.get();
    }

    public static List<Integer> getAllSlotsWithStack(Player player, Predicate<ItemStack> action) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (!action.test(player.getInventory().getItem(i))) continue;
            slots.add(i);
        }
        return slots;
    }

    public static ItemStack findItemInInv(Player player, Predicate<ItemStack> is) {
        if (is.test(player.getMainHandItem())) {
            return player.getMainHandItem();
        }
        if (is.test(player.getOffhandItem())) {
            return player.getOffhandItem();
        }
        Inventory inv = player.getInventory();
        int size = inv.getContainerSize();
        for (int i = 0; i < size; ++i) {
            ItemStack s = inv.getItem(i);
            if (!is.test(s)) continue;
            return s;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack findItemInInv(Player player, Predicate<ItemStack> is, Function<ItemStack, ItemStack> map) {
        ItemStack resultStack;
        if (ModList.get().isLoaded("curios") && !(resultStack = CuriosTools.getFirstItemFromCuriosInv(player, is)).isEmpty()) {
            return map.apply(resultStack);
        }
        if (is.test(player.getMainHandItem())) {
            return map.apply(player.getMainHandItem());
        }
        if (is.test(player.getOffhandItem())) {
            return map.apply(player.getOffhandItem());
        }
        Inventory inv = player.getInventory();
        int size = inv.getContainerSize();
        for (int i = 0; i < size; ++i) {
            ItemStack s = inv.getItem(i);
            if (!is.test(s)) continue;
            return map.apply(s);
        }
        return ItemStack.EMPTY;
    }

    public static ICapabilityProvider createCurioProvider(ItemStack stack, CompoundTag unused) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosTools.getSlowProvider(stack);
        }
        return null;
    }
}

