/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.util;

import committee.nova.mods.avaritia.api.client.util.color.ColorMC;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;

public class StringUtils {
    public static final String METHOD_SET_PREFIX = "set";
    public static final String METHOD_GET_PREFIX = "get";
    public static final String COMMON_MARK = ",<.>/?;:'\"[{]}\\|`~!@#$%^&*()-_=+\uff0c\u300a\u3002\u300b\u3001\uff1f\uff1b\uff1a\u2018\u201c\u3010\u3011\u00b7~\uff01\uffe5\u2026\uff08\uff09\u2014";
    public static final SecureRandom DEFAULT_NUMBER_GENERATOR = new SecureRandom();
    public static final char[] DEFAULT_ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    public static final char[] NUMBER_ALPHABET = "0123456789".toCharArray();
    public static final int DEFAULT_SIZE = 21;
    private static final String[] NUM = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] UNIT = new String[]{"", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe\u4e07", "\u4f70\u4e07", "\u4edf\u4e07", "\u4ebf", "\u62fe\u4ebf", "\u4f70\u4ebf", "\u4edf\u4ebf", "\u5146", "\u62fe\u5146", "\u4f70\u5146", "\u4edf\u5146", "\u4eac", "\u62fe\u4eac", "\u4f70\u4eac", "\u4edf\u4eac", "\u5793", "\u62fe\u5793", "\u4f70\u5793", "\u4edf\u5793", "\u79ed", "\u62fe\u79ed", "\u4f70\u79ed", "\u4edf\u79ed", "\u7a70", "\u62fe\u7a70", "\u4f70\u7a70", "\u4edf\u7a70", "\u6c9f", "\u62fe\u6c9f", "\u4f70\u6c9f", "\u4edf\u6c9f", "\u6da7", "\u62fe\u6da7", "\u4f70\u6da7", "\u4edf\u6da7", "\u6b63", "\u62fe\u6b63", "\u4f70\u6b63", "\u4edf\u6b63", "\u8f7d", "\u62fe\u8f7d", "\u4f70\u8f7d", "\u4edf\u8f7d"};
    private static final String[] DECIMAL = new String[]{"\u89d2", "\u5206"};
    public static final String FORMAT_REGEX = "%(\\d+\\$)?([-#+ 0,(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";

    public static boolean isCommonMark(String s) {
        if (s.length() != 1) {
            return false;
        }
        return COMMON_MARK.contains(s);
    }

    public static String getByLine(String s, int start, int end, String suffix) {
        String code;
        if (start > end) {
            return s;
        }
        if (s.contains("\r\n")) {
            code = "\r\n";
        } else if (s.contains("\r")) {
            code = "\r";
        } else if (s.contains("\n")) {
            code = "\n";
        } else {
            return s;
        }
        String[] split = s.split(code);
        if (start > split.length) {
            return s;
        }
        if (end >= split.length) {
            StringBuilder back = new StringBuilder();
            for (int i = start - 1; i < split.length; ++i) {
                if (i != start - 1) {
                    back.append(code);
                }
                back.append(split[i]);
            }
            return back.toString();
        }
        StringBuilder back = new StringBuilder();
        for (int i = start - 1; i < end; ++i) {
            if (i != start - 1) {
                back.append(code);
            }
            back.append(split[i]);
        }
        if (!"".equals(suffix)) {
            back.append(code).append(suffix.replace("[num]", "" + (split.length - end)));
        }
        return back.toString();
    }

    public static String toString(int[] a) {
        return StringUtils.toString(a, ',');
    }

    public static String toString(int[] a, char separator) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.toString();
            }
            b.append(separator);
            ++i;
        }
    }

    public static String toString(long[] a) {
        return StringUtils.toString(a, ',');
    }

    public static String toString(long[] a, char separator) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.toString();
            }
            b.append(separator);
            ++i;
        }
    }

    public static String toString(Collection<?> a) {
        return StringUtils.toString(a, ',');
    }

    public static String toString(Collection<?> a, char separator) {
        if (a == null) {
            return "null";
        }
        int iMax = a.size() - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        for (Object o : a) {
            b.append(o);
            if (++i > iMax) continue;
            b.append(separator);
        }
        return b.toString();
    }

    public static String escapeExprSpecialWord(String keyword) {
        if (!StringUtils.isNullOrEmpty(keyword)) {
            String[] fbsArr;
            for (String key : fbsArr = new String[]{"\\", "$", "(", ")", "*", "+", ".", "[", "]", "?", "^", "{", "}", "|"}) {
                if (!keyword.contains(key)) continue;
                keyword = keyword.replace(key, "\\" + key);
            }
        }
        return keyword;
    }

    public static boolean stringToBoolean(String s) {
        if (null == s) {
            return false;
        }
        switch (s.toLowerCase().trim()) {
            case "1": 
            case "\u771f": 
            case "\u662f": 
            case "true": 
            case "y": 
            case "t": {
                return true;
            }
        }
        return false;
    }

    public static String convertToString(String[][] stringArray, String x, String y) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                sb.append(stringArray[i][j]);
                if (j >= stringArray[i].length - 1) continue;
                sb.append(x);
            }
            if (i >= stringArray.length - 1) continue;
            sb.append(y);
        }
        return sb.toString();
    }

    public static boolean isNullOrEmpty(String s) {
        return null == s || s.isEmpty();
    }

    public static boolean isNullOrEmptyEx(String s) {
        return null == s || s.trim().isEmpty();
    }

    public static boolean isNotNullOrEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    public static boolean isNotNull(Object s) {
        return s != null;
    }

    public static String nullToEmpty(String s) {
        return s == null ? "" : s;
    }

    public static String substring(String s, int start, int end) {
        if (StringUtils.isNullOrEmpty(s)) {
            return "";
        }
        int length = s.length();
        if (end < start) {
            return s;
        }
        if (length >= start && length >= end) {
            return s.substring(start, end);
        }
        return s;
    }

    public static String substring(String s, int start) {
        if (StringUtils.isNullOrEmpty(s)) {
            return "";
        }
        int length = s.length();
        if (start > length) {
            return s;
        }
        return s.substring(start);
    }

    public static String substringEnd(String s, int len) {
        if (StringUtils.isNullOrEmpty(s)) {
            return "";
        }
        int length = s.length();
        if (len > length) {
            return s;
        }
        return s.substring(0, length - len);
    }

    public static String toString(String s, String emptyDefault) {
        return StringUtils.isNullOrEmpty(s) ? emptyDefault : s;
    }

    @NonNull
    public static String replaceLine(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("<br>", "\n").replaceAll("\\\\n", "\n").replaceAll("\\\\r", "\r").replaceAll("\\n", "\n").replaceAll("\\r", "\r").replaceAll("\r\n", "\n");
    }

    public static int getLineCount(String s) {
        if (StringUtils.isNullOrEmpty(s)) {
            return 0;
        }
        return StringUtils.replaceLine(s).split("\n").length;
    }

    public static String getAvatarUrl(long qq, int size) {
        return "http://q.qlogo.cn/g?b=qq&nk=" + qq + "&s=" + size;
    }

    public static String toChineseCapitalized(BigDecimal amount) {
        int digit;
        int i;
        StringBuilder sb = new StringBuilder();
        int scale = amount.scale();
        if (scale > 2) {
            amount = amount.setScale(2, RoundingMode.HALF_UP);
        }
        String str = amount.toString();
        String[] parts = str.split("\\.");
        String integerPart = parts[0];
        Object decimalPart = "00";
        if (parts.length > 1) {
            decimalPart = parts[1];
        }
        int integerLen = integerPart.length();
        int decimalLen = ((String)decimalPart).length();
        if (integerLen == 1 && integerPart.charAt(0) == '0') {
            sb.append(NUM[0]);
        } else {
            for (i = 0; i < integerLen; ++i) {
                digit = integerPart.charAt(i) - 48;
                int unitIndex = integerLen - i - 1;
                int unit = unitIndex % 4;
                if (digit == 0) {
                    if (unit != 0 && sb.length() > 0 && sb.charAt(sb.length() - 1) != '\u96f6') {
                        sb.append(NUM[0]);
                    }
                } else {
                    sb.append(NUM[digit]);
                    sb.append(UNIT[unit]);
                }
                if (unit != 0 || unitIndex <= 0 || sb.charAt(sb.length() - 1) == '\u4ebf') continue;
                sb.append(UNIT[unitIndex]);
            }
        }
        sb.append("\u5143");
        if (decimalLen == 1) {
            decimalPart = (String)decimalPart + "0";
        }
        if (!((String)decimalPart).equals("00")) {
            for (i = 0; i < decimalLen; ++i) {
                digit = ((String)decimalPart).charAt(i) - 48;
                if (digit == 0) continue;
                sb.append(NUM[digit]);
                sb.append(DECIMAL[i]);
            }
        }
        if (((String)decimalPart).equals("00")) {
            sb.append("\u6574");
        }
        return sb.toString();
    }

    public static int toInt(String s) {
        return StringUtils.toInt(s, 0);
    }

    public static int toInt(String s, int defaultValue) {
        int result = defaultValue;
        if (StringUtils.isNotNullOrEmpty(s)) {
            try {
                result = Integer.parseInt(s.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static long toLong(String s) {
        return StringUtils.toLong(s, 0L);
    }

    public static long toLong(String s, long defaultValue) {
        long result = defaultValue;
        if (StringUtils.isNotNullOrEmpty(s)) {
            try {
                result = Long.parseLong(s.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static float toFloat(String s) {
        return StringUtils.toFloat(s, 0.0f);
    }

    public static float toFloat(String s, float defaultValue) {
        float result = defaultValue;
        if (StringUtils.isNotNullOrEmpty(s)) {
            try {
                result = Float.parseFloat(s.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static double toDouble(String s) {
        return StringUtils.toDouble(s, 0.0);
    }

    public static double toDouble(String s, double defaultValue) {
        double result = defaultValue;
        if (StringUtils.isNotNullOrEmpty(s)) {
            try {
                result = Double.parseDouble(s.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static BigDecimal toBigDecimal(String s) {
        return StringUtils.toBigDecimal(s, BigDecimal.ZERO);
    }

    public static BigDecimal toBigDecimal(String s, BigDecimal defaultValue) {
        BigDecimal result = defaultValue;
        if (StringUtils.isNotNullOrEmpty(s)) {
            try {
                result = new BigDecimal(s.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String intToRoman(int num) {
        StringBuilder roman = new StringBuilder();
        int[] values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] symbols = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        for (int i = 0; i < values.length; ++i) {
            while (num >= values[i]) {
                roman.append(symbols[i]);
                num -= values[i];
            }
        }
        return roman.toString();
    }

    public static String toPercent(double num) {
        return StringUtils.toPercent(num, 2);
    }

    public static String toPercent(double num, int scale) {
        return String.format(String.format("%%.%df%%%%", scale), num * 100.0);
    }

    public static String toPercent(BigDecimal num) {
        return StringUtils.toPercent(num.doubleValue());
    }

    public static String toPercent(BigDecimal num, int scale) {
        return StringUtils.toPercent(num.doubleValue(), scale);
    }

    public static String toFixed(double d, int scale) {
        return new BigDecimal(d).setScale(scale, RoundingMode.HALF_UP).toPlainString();
    }

    public static String toFixedEx(double d, int scale) {
        return StringUtils.toFixed(d, scale).replaceAll("(\\.\\d*?)0+$", "$1").replaceAll("[.]$", "");
    }

    public static String toFixedEx(BigDecimal d, int scale) {
        return d.setScale(scale, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString().replaceAll("(\\.\\d*?)0+$", "$1").replaceAll("[.]$", "");
    }

    public static String getString(String s, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String format(String string, Object ... args) {
        StringBuilder result = new StringBuilder();
        Pattern pattern = Pattern.compile(FORMAT_REGEX);
        Matcher matcher = pattern.matcher(string);
        int i = 0;
        while (matcher.find()) {
            int index;
            String placeholder = matcher.group();
            int n = index = placeholder.contains("$") ? StringUtils.toInt(placeholder.split("\\$")[0].substring(1)) - 1 : -1;
            if (index == -1) {
                index = i;
            }
            String formattedArg = placeholder;
            if (index < args.length) {
                formattedArg = StringUtils.formatArgument(placeholder, args[index]);
            }
            string = string.replaceFirst(Pattern.quote(placeholder), formattedArg.replaceAll("\\$", "\\\\\\$"));
            ++i;
        }
        return string;
    }

    private static String formatArgument(String placeholder, Object arg) {
        if (arg == null) {
            return "null";
        }
        try {
            return String.format(placeholder.replaceAll("^%\\d+\\$", "%"), arg);
        }
        catch (Exception e) {
            return arg.toString();
        }
    }

    public static int argbToHex(String argb) {
        try {
            if (argb.startsWith("#")) {
                return (int)Long.parseLong(argb.substring(1), 16);
            }
            if (argb.startsWith("0x")) {
                return (int)Long.parseLong(argb.substring(2), 16);
            }
            return (int)Long.parseLong(argb, 16);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String argbToMinecraftColorString(int color) {
        return "\u00a7" + StringUtils.argbToMinecraftColor(color).getCode();
    }

    public static ColorMC argbToMinecraftColor(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        double closestDistance = Double.MAX_VALUE;
        ColorMC result = ColorMC.WHITE;
        for (ColorMC mcColor : ColorMC.values()) {
            int colorRGB = mcColor.getColor();
            int r = colorRGB >> 16 & 0xFF;
            int g = colorRGB >> 8 & 0xFF;
            int b = colorRGB & 0xFF;
            double distance = Math.sqrt(2.0 * Math.pow(red - r, 2.0) + 4.0 * Math.pow(green - g, 2.0) + 3.0 * Math.pow(blue - b, 2.0));
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            result = mcColor;
        }
        return result;
    }

    public static String toPascalCase(String input) {
        if (StringUtils.isNullOrEmptyEx(input)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : input.toCharArray()) {
            if (Character.isLetterOrDigit(c)) {
                if (capitalizeNext) {
                    result.append(Character.toUpperCase(c));
                    capitalizeNext = false;
                    continue;
                }
                result.append(Character.toLowerCase(c));
                continue;
            }
            capitalizeNext = true;
        }
        return result.toString();
    }
}

