/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.util.vec.uv;

import committee.nova.mods.avaritia.api.client.render.CCRenderState;
import committee.nova.mods.avaritia.api.util.vec.IrreversibleTransformationException;
import committee.nova.mods.avaritia.api.util.vec.uv.UV;
import committee.nova.mods.avaritia.api.util.vec.uv.UVTransformation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.jetbrains.annotations.Nullable;

public class MultiIconTransformation
extends UVTransformation {
    public TextureAtlasSprite[] icons;
    @Nullable
    private TextureAtlasSprite icon;

    public MultiIconTransformation(TextureAtlasSprite ... icons) {
        this.icons = icons;
    }

    public MultiIconTransformation(MultiIconTransformation other) {
        this((TextureAtlasSprite[])other.icons.clone());
        this.icon = null;
    }

    @Override
    public void operate(CCRenderState ccrs) {
        super.operate(ccrs);
        ccrs.sprite = this.icon;
    }

    @Override
    public void apply(UV uv) {
        this.icon = this.icons[uv.tex % this.icons.length];
        uv.u = this.icon.getU(uv.u * 16.0);
        uv.v = this.icon.getV(uv.v * 16.0);
    }

    @Override
    public UVTransformation inverse() {
        throw new IrreversibleTransformationException(this);
    }

    @Override
    public MultiIconTransformation copy() {
        return new MultiIconTransformation(this);
    }
}

