/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model.loader;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import committee.nova.mods.avaritia.client.model.loader.CosmicArcBakeModel;
import committee.nova.mods.avaritia.client.model.loader.base.BaseGeometry;
import committee.nova.mods.avaritia.client.model.loader.base.BaseModelLoader;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;

public class CosmicArcModelLoader
extends BaseModelLoader<CosmicArcGeometry> {
    public static final CosmicArcModelLoader INSTANCE = new CosmicArcModelLoader();

    public CosmicArcGeometry read(JsonObject modelContents, JsonDeserializationContext deserializationContext) throws JsonParseException {
        List<ResourceLocation> cosmicMaskTexture = this.getMasks(modelContents, "cosmic");
        BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)this.clear(modelContents, "cosmic"), BlockModel.class);
        return new CosmicArcGeometry(baseModel, cosmicMaskTexture);
    }

    public static class CosmicArcGeometry
    extends BaseGeometry<CosmicArcGeometry> {
        private final List<ResourceLocation> maskTextures;

        public CosmicArcGeometry(BlockModel baseModel, List<ResourceLocation> maskTextures) {
            super(baseModel);
            this.maskTextures = maskTextures;
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
            BakedModel bakedBaseModel = this.baseModel.bake(baker, this.baseModel, spriteGetter, modelState, modelLocation, true);
            return new CosmicArcBakeModel(bakedBaseModel, this.maskTextures);
        }
    }
}

