/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model.loader;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import committee.nova.mods.avaritia.client.model.loader.HellBakeModel;
import committee.nova.mods.avaritia.client.model.loader.base.BaseGeometry;
import committee.nova.mods.avaritia.client.model.loader.base.BaseModelLoader;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;

public class HellModelLoader
extends BaseModelLoader<HellGeometry> {
    public static final HellModelLoader INSTANCE = new HellModelLoader();

    public HellGeometry read(JsonObject modelContents, JsonDeserializationContext deserializationContext) throws JsonParseException {
        BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)this.clear(modelContents, "hell"), BlockModel.class);
        List<ResourceLocation> hellMaskTexture = this.getMasks(modelContents, "hell");
        return new HellGeometry(baseModel, hellMaskTexture);
    }

    public static class HellGeometry
    extends BaseGeometry<HellGeometry> {
        private final List<ResourceLocation> maskTextures;

        public HellGeometry(BlockModel baseModel, List<ResourceLocation> maskTextures) {
            super(baseModel);
            this.maskTextures = maskTextures;
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
            BakedModel baseBakedModel = this.baseModel.bake(baker, this.baseModel, spriteGetter, modelState, modelLocation, true);
            return new HellBakeModel(baseBakedModel, this.maskTextures);
        }
    }
}

