/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.NotNull;

public class ChargeParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    public ChargeParticle(ClientLevel world, double x, double y, double z, SpriteSet sprites) {
        super(world, x, y, z);
        this.lifetime = 8 + this.random.nextInt(4);
        this.setParticleSpeed(0.0, 0.0, 0.0);
        this.scale(1.25f);
        this.sprites = sprites;
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.sprites);
        }
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public record Factory(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(@NotNull SimpleParticleType simpleParticleType, @NotNull ClientLevel world, double x, double y, double z, double velX, double velY, double velZ) {
            return new ChargeParticle(world, x, y, z, this.sprites);
        }
    }
}

