/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.render.util;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import committee.nova.mods.avaritia.Res;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class ArcRender {
    public static final RenderType ARC_RENDER_TYPE = new RenderType.CompositeRenderType("arc_render_type", DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS, 256, false, true, RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(Res.ARC_TEX, false, false)).setShaderState(RenderStateShard.POSITION_TEX_SHADER).setCullState(RenderStateShard.NO_CULL).setOutputState(RenderStateShard.ITEM_ENTITY_TARGET).setTransparencyState(RenderStateShard.LIGHTNING_TRANSPARENCY).createCompositeState(false));
    private static final float THICKNESS_VARIATION = 0.4f;
    private static final float MIN_THICKNESS_FACTOR = 0.1f;
    private static final double EPSILON = 1.0E-6;

    public static void renderArc(PoseStack ps, MultiBufferSource mbs, long seed, float sx, float sy, float sz, float ex, float ey, float ez, float thickness, int segments) {
        Vec3 side;
        VertexConsumer vc = mbs.getBuffer(ARC_RENDER_TYPE);
        Matrix4f matrix = ps.last().pose();
        Random rnd = new Random(seed);
        Vec3 end = new Vec3((double)ex, (double)ey, (double)ez);
        Vec3 start = new Vec3((double)sx, (double)sy, (double)sz);
        Vec3 delta = end.subtract(start);
        if (delta.lengthSqr() < 1.0E-12) {
            return;
        }
        Vec3 direction = delta.normalize();
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        if (Math.abs(direction.y()) > 0.999999) {
            up = new Vec3(1.0, 0.0, 0.0);
        }
        if ((side = direction.cross(up)).lengthSqr() < 1.0E-12 && (side = direction.cross(up = new Vec3(0.0, 0.0, 1.0))).lengthSqr() < 1.0E-12) {
            if (direction.lengthSqr() > 1.0E-12) {
                Vec3 arbitraryNonParallel = Math.abs(direction.x()) < 0.9 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(0.0, 1.0, 0.0);
                side = direction.cross(arbitraryNonParallel);
                if (side.lengthSqr() < 1.0E-12) {
                    return;
                }
            } else {
                return;
            }
        }
        side = side.normalize();
        Vec3 renderUp = side.cross(direction).normalize();
        Vec3 prevL = start;
        Vec3 prevR = start;
        float baseHalfThickness = thickness * 0.5f;
        for (int i = 1; i <= segments; ++i) {
            float t = (float)i / (float)segments;
            Vec3 currentMidpoint = start.add(delta.scale((double)t));
            float displacementMagnitude = baseHalfThickness * ((float)Math.PI * 2);
            float falloff = 1.0f - (float)Math.pow(2.0 * (double)t - 1.0, 2.0);
            displacementMagnitude *= falloff;
            double angle = rnd.nextDouble() * 6.2831854820251465;
            Vec3 displacementDir = side.scale(Math.cos(angle)).add(renderUp.scale(Math.sin(angle)));
            Vec3 currentPos = currentMidpoint.add(displacementDir.scale((double)(displacementMagnitude *= rnd.nextFloat() * 2.0f - 1.0f)));
            float currentHalfThickness = baseHalfThickness;
            currentHalfThickness *= 1.0f + 0.4f * (rnd.nextFloat() * 2.0f - 1.0f);
            currentHalfThickness = Math.max(baseHalfThickness * 0.1f, currentHalfThickness);
            Vec3 currentL = currentPos.subtract(side.scale((double)currentHalfThickness));
            Vec3 currentR = currentPos.add(side.scale((double)currentHalfThickness));
            float u0 = (float)(i - 1) / (float)segments;
            float u1 = (float)i / (float)segments;
            vc.vertex(matrix, (float)prevL.x(), (float)prevL.y(), (float)prevL.z()).uv(u0, 0.0f).endVertex();
            vc.vertex(matrix, (float)prevR.x(), (float)prevR.y(), (float)prevR.z()).uv(u0, 1.0f).endVertex();
            vc.vertex(matrix, (float)currentR.x(), (float)currentR.y(), (float)currentR.z()).uv(u1, 1.0f).endVertex();
            vc.vertex(matrix, (float)currentL.x(), (float)currentL.y(), (float)currentL.z()).uv(u1, 0.0f).endVertex();
            prevL = currentL;
            prevR = currentR;
        }
    }
}

