/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.api.client.screen.BaseContainerScreen;
import committee.nova.mods.avaritia.api.client.screen.component.SimpleScrollBar;
import committee.nova.mods.avaritia.common.menu.InfinityChestMenu;
import committee.nova.mods.avaritia.common.net.chest.C2SInfinityChestFilterPack;
import committee.nova.mods.avaritia.core.chest.ClientChestHandler;
import committee.nova.mods.avaritia.core.chest.ClientChestManager;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.util.StorageUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;

public class InfinityChestScreen
extends BaseContainerScreen<InfinityChestMenu> {
    private int blitOffset;
    private static final ResourceLocation GUI_IMG = Res.INFINITY_CHEST_TEX;
    private final String ownerName;
    private String lastHoveredItem = "";
    private long lastCount = 0L;
    private String lastFormatCountTemp = "";
    private SortButton sortButton;
    private ItemScrollBar scrollBar;
    private EditBox searchBox;

    public InfinityChestScreen(InfinityChestMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title, null, 302, 274, 550, 550);
        this.ownerName = ClientChestManager.getInstance().getUserName(((InfinityChestMenu)this.getMenu()).owner);
    }

    @Override
    protected void subInit() {
        super.subInit();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.scrollBar = new ItemScrollBar(this.leftPos + 282, this.topPos + 16, 12, 160);
        this.scrollBar.setScrolledOn(((InfinityChestMenu)this.menu).chestContainer.getScrollOn());
        this.addRenderableWidget((GuiEventListener)this.scrollBar);
        this.addRenderableWidget((GuiEventListener)new ToggleLockButton(this.leftPos + 231, this.topPos + 187));
        this.sortButton = new SortButton(this.leftPos + 249, this.topPos + 187);
        this.addRenderableWidget((GuiEventListener)this.sortButton);
        this.searchBox = new EditBox(this.font, this.leftPos + 187, this.topPos + 4, 89, 10, (Component)Component.translatable((String)"gui.avaritia.search"));
        this.searchBox.setMaxLength(64);
        this.searchBox.setBordered(false);
        this.searchBox.setValue(((InfinityChestMenu)this.menu).filter);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        ((InfinityChestMenu)this.menu).chestContainer.refreshContainer(true);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX + 50, this.inventoryLabelY + 108, 0x404040, false);
    }

    @Override
    protected void renderBgs(GuiGraphics pGuiGraphics, float pPartialTick, int pX, int pY) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        pGuiGraphics.blit(GUI_IMG, x, y, this.blitOffset, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.bgImgWidth, this.bgImgHeight);
    }

    @Override
    protected void renderFg(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderDummyCount(pGuiGraphics);
    }

    public void renderSlot(@NotNull GuiGraphics guiGraphics, Slot slot) {
        if (slot.index >= 36) {
            ItemStack stack = slot.getItem();
            int originalCount = stack.getCount();
            if (stack.getCount() > 1) {
                stack.setCount(1);
                super.renderSlot(guiGraphics, slot);
                stack.setCount(originalCount);
            } else {
                super.renderSlot(guiGraphics, slot);
            }
            return;
        }
        super.renderSlot(guiGraphics, slot);
    }

    public void renderDummyCount(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.pose();
        for (int i = 0; i < ((InfinityChestMenu)this.menu).chestContainer.formatCount.size(); ++i) {
            Slot slot = (Slot)((InfinityChestMenu)this.menu).slots.get(i + 36);
            String count = ((InfinityChestMenu)this.menu).chestContainer.formatCount.get(i);
            this.setBlitOffset(100);
            RenderSystem.enableDepthTest();
            float fontSize = 0.5f;
            poseStack.pushPose();
            poseStack.translate((double)(this.leftPos + slot.x), (double)(this.topPos + slot.y), 300.0);
            poseStack.scale(fontSize, fontSize, 1.0f);
            float f = (16.0f - (float)this.font.width(count) * fontSize) / fontSize;
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, count, f, (16.0f - 9.0f * fontSize) / fontSize, 0xFFFFFF, false);
            poseStack.popPose();
            this.setBlitOffset(0);
        }
    }

    @ParametersAreNonnullByDefault
    protected void renderTooltip(GuiGraphics pPoseStack, int pX, int pY) {
        if (this.hoveredSlot != null) {
            if (this.hoveredSlot.index >= 36) {
                if (((InfinityChestMenu)this.menu).getCarried().getCount() == 1) {
                    this.renderObjectStorageTooltip(pPoseStack, pX, pY);
                } else {
                    this.renderCounterTooltip(pPoseStack, pX, pY);
                }
            } else if (!this.hoveredSlot.getItem().isEmpty() && ((InfinityChestMenu)this.menu).getCarried().isEmpty()) {
                pPoseStack.renderTooltip(this.font, this.hoveredSlot.getItem(), pX, pY);
            }
        } else if (this.searchBox.isHovered()) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.translatable((String)"gui.avaritia.search.tip1"));
            list.add(Component.translatable((String)"gui.avaritia.search.tip2"));
            list.add(Component.translatable((String)"gui.avaritia.search.tip3"));
            pPoseStack.renderComponentTooltip(this.font, list, pX, pY);
        }
    }

    private void renderCounterTooltip(GuiGraphics pPoseStack, int pMouseX, int pMouseY) {
        if (this.hoveredSlot.index - 36 >= ((InfinityChestMenu)this.menu).chestContainer.viewingObject.size()) {
            return;
        }
        String hoveredObject = ((InfinityChestMenu)this.menu).chestContainer.viewingObject.get(this.hoveredSlot.index - 36);
        List components = InfinityChestScreen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)this.hoveredSlot.getItem());
        long count = ((InfinityChestMenu)this.menu).chest.getRealItemAmount(hoveredObject);
        if (!hoveredObject.equals(this.lastHoveredItem)) {
            String formatCount = StorageUtils.DECIMAL_FORMAT.format(count);
            components.add(Component.literal((String)formatCount));
            this.lastHoveredItem = hoveredObject;
            this.lastCount = count;
            this.lastFormatCountTemp = formatCount;
        } else if (count == this.lastCount) {
            components.add(Component.literal((String)this.lastFormatCountTemp));
        } else {
            Object formatCount = StorageUtils.DECIMAL_FORMAT.format(count);
            long count2 = count - this.lastCount;
            String formatCount2 = StorageUtils.DECIMAL_FORMAT.format(count2);
            formatCount = count2 >= 0L ? (String)formatCount + "  |  +\u00a7a" + formatCount2 : (String)formatCount + "  |  \u00a7c" + formatCount2;
            components.add(Component.literal((String)formatCount));
            this.lastCount = count;
            this.lastFormatCountTemp = formatCount;
        }
        pPoseStack.renderTooltip(this.font, components, this.hoveredSlot.getItem().getTooltipImage(), pMouseX, pMouseY);
    }

    private void renderObjectStorageTooltip(GuiGraphics pPoseStack, int pMouseX, int pMouseY) {
        boolean hasCapability;
        ItemStack carried = ((InfinityChestMenu)this.menu).getCarried();
        boolean bl = hasCapability = carried.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent() || carried.getCapability(ForgeCapabilities.ENERGY).isPresent() || carried.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent();
        if (hasCapability) {
            ArrayList components = Lists.newArrayList();
            if (this.hoveredSlot.index - 36 < ((InfinityChestMenu)this.menu).chestContainer.viewingObject.size()) {
                components.add(Component.translatable((String)"gui.avaritia.capability.tip1", (Object[])new Object[]{this.hoveredSlot.getItem().getHoverName()}));
            }
            components.add(Component.translatable((String)"gui.avaritia.capability.tip2"));
            components.add(Component.translatable((String)"gui.avaritia.capability.tip3"));
            pPoseStack.renderTooltip(this.font, (List)components, ItemStack.EMPTY.getTooltipImage(), pMouseX, pMouseY);
        } else {
            this.renderCounterTooltip(pPoseStack, pMouseX, pMouseY);
        }
    }

    public void containerTick() {
        super.containerTick();
        if (this.searchBox.isFocused()) {
            this.searchBox.tick();
        }
    }

    public void onClose() {
        NetworkHandler.CHANNEL.sendToServer((Object)new C2SInfinityChestFilterPack(((InfinityChestMenu)this.menu).containerId, ((InfinityChestMenu)this.menu).filter));
        ((ClientChestHandler)((InfinityChestMenu)this.menu).chest).removeListener();
        super.onClose();
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 1 && this.searchBox.isMouseOver(pMouseX, pMouseY)) {
            ((InfinityChestMenu)this.menu).filter = "";
            this.searchBox.setValue("");
            ((InfinityChestMenu)this.menu).chestContainer.refreshContainer(true);
            this.searchBox.setFocused(true);
            this.searchBox.setEditable(true);
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrollBar.isScrolling()) {
            this.scrollBar.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.mouseReleased(pMouseX, pMouseY, pButton);
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.searchBox.isFocused() && pKeyCode >= 48 && pKeyCode <= 90) {
            return true;
        }
        if (pKeyCode == 340) {
            ((InfinityChestMenu)this.menu).LShifting = true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        String s;
        if (this.searchBox.isFocused() && !(s = this.searchBox.getValue().toLowerCase()).equals(((InfinityChestMenu)this.menu).filter)) {
            ((InfinityChestMenu)this.menu).filter = s;
            ((InfinityChestMenu)this.menu).chestContainer.refreshContainer(true);
        }
        if (pKeyCode == 340) {
            ((InfinityChestMenu)this.menu).LShifting = false;
            ((InfinityChestMenu)this.menu).chestContainer.refreshContainer(true);
        }
        return super.keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pDelta) {
        if (pMouseX >= (double)(this.leftPos + 5) && pMouseX <= (double)(this.leftPos + 214) && pMouseY >= (double)(this.topPos + 17) && pMouseY <= (double)(this.topPos + 18 + 119) && this.scrollBar.canScroll()) {
            if (pDelta <= 0.0) {
                this.scrollBar.setScrolledOn(((InfinityChestMenu)this.menu).chestContainer.onMouseScrolled(false));
            } else {
                this.scrollBar.setScrolledOn(((InfinityChestMenu)this.menu).chestContainer.onMouseScrolled(true));
            }
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pDelta);
    }

    protected boolean isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        return (pMouseX -= (double)i) >= (double)pX && pMouseX < (double)(pX + pWidth) && (pMouseY -= (double)j) >= (double)pY && pMouseY < (double)(pY + pHeight);
    }

    private void toggleLock() {
        if (((InfinityChestMenu)this.menu).owner.equals(((InfinityChestMenu)this.menu).player.getUUID()) || ((InfinityChestMenu)this.menu).owner.equals(Const.AVARITIA_FAKE_PLAYER.getId())) {
            ((InfinityChestMenu)this.menu).locked = !((InfinityChestMenu)this.menu).locked;
            this.searchBox.setFocused(false);
            NetworkHandler.CHANNEL.sendToServer((Object)new C2SInfinityChestFilterPack(((InfinityChestMenu)this.menu).containerId, ((InfinityChestMenu)this.menu).filter));
            this.minecraft.gameMode.handleInventoryButtonClick(((InfinityChestMenu)this.menu).containerId, 0);
        }
    }

    private void cycleSort() {
        if (InputConstants.isKeyDown((long)this.getMinecraft().getWindow().getWindow(), (int)340)) {
            ((InfinityChestMenu)this.menu).reverseSort();
            this.minecraft.gameMode.handleInventoryButtonClick(((InfinityChestMenu)this.menu).containerId, 2);
        } else {
            ((InfinityChestMenu)this.menu).nextSort();
            this.minecraft.gameMode.handleInventoryButtonClick(((InfinityChestMenu)this.menu).containerId, 1);
        }
    }

    private String getSortKey(int sortType) {
        return switch (sortType) {
            case 0, 1 -> "gui.avaritia.sort.id";
            case 2, 3 -> "gui.avaritia.sort.nid";
            case 4, 5 -> "gui.avaritia.sort.mirror_id";
            case 6, 7 -> "gui.avaritia.sort.count";
            default -> "";
        };
    }

    @Generated
    public void setBlitOffset(int blitOffset) {
        this.blitOffset = blitOffset;
    }

    @Generated
    public int getBlitOffset() {
        return this.blitOffset;
    }

    private class ItemScrollBar
    extends SimpleScrollBar {
        private int lastObjectListSize;

        public ItemScrollBar(int x, int y, int weight, int height) {
            super(x, y, weight, height);
            this.setScrollTagSize();
            this.lastObjectListSize = ((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).menu).chestContainer.sortedItems.size();
        }

        public void setScrollTagSize() {
            double v = (double)this.height * (9.0 / Math.ceil((double)((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).menu).chestContainer.sortedItems.size() / 15.0));
            this.setScrollTagSize(v);
        }

        @Override
        public void draggedTo(double scrolledOn) {
            ((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).menu).chestContainer.onScrollTo(scrolledOn);
        }

        @Override
        public void beforeRender() {
            if (((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).menu).chestContainer.sortedItems.size() != this.lastObjectListSize) {
                this.setScrollTagSize();
                this.lastObjectListSize = ((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).menu).chestContainer.sortedItems.size();
            }
        }
    }

    private class ToggleLockButton
    extends ImageButton {
        public ToggleLockButton(int pX, int pY) {
            super(pX, pY, 17, 18, 303, 36, GUI_IMG, pButton -> InfinityChestScreen.this.toggleLock());
            MutableComponent componentB = Component.translatable((String)"gui.avaritia.owner", (Object[])new Object[]{"\u00a7c" + InfinityChestScreen.this.ownerName});
            MutableComponent componentC = Component.translatable((String)"gui.avaritia.public");
            if (((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).menu).locked) {
                this.setTooltip(Tooltip.create((Component)componentB));
            } else {
                this.setTooltip(Tooltip.create((Component)componentC));
            }
        }

        @ParametersAreNonnullByDefault
        public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            int uOffset;
            int n = uOffset = ((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).menu).locked ? 303 : 320;
            if (this.isHovered) {
                pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), (float)uOffset, (float)(this.yTexStart + 18), this.width, this.height, 550, 550);
            } else {
                pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), (float)uOffset, (float)this.yTexStart, this.width, this.height, 550, 550);
            }
        }
    }

    private class SortButton
    extends ImageButton {
        public SortButton(int pX, int pY) {
            super(pX, pY, 17, 18, 303, 0, GUI_IMG, pButton -> InfinityChestScreen.this.cycleSort());
        }

        @ParametersAreNonnullByDefault
        public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            int xOffset = ((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).menu).sortType * 17 + this.xTexStart;
            if (this.isHovered) {
                pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), (float)xOffset, (float)(this.yTexStart + 18), this.width, this.height, 550, 550);
            } else {
                pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), (float)xOffset, (float)this.yTexStart, this.width, this.height, 550, 550);
            }
            list.add(Component.translatable((String)InfinityChestScreen.this.getSortKey(((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).menu).sortType)).getVisualOrderText());
            if (((InfinityChestMenu)((InfinityChestScreen)InfinityChestScreen.this).menu).sortType % 2 == 0) {
                list.add(Component.translatable((String)"gui.avaritia.sort.ascending").getVisualOrderText());
            } else {
                list.add(Component.translatable((String)"gui.avaritia.sort.descending").getVisualOrderText());
            }
            list.add(Component.translatable((String)"gui.avaritia.line").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.sort.tip1").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.sort.tip2").getVisualOrderText());
            if (this.isHovered) {
                InfinityChestScreen.this.setTooltipForNextRenderPass(list);
            }
        }
    }
}

