/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.api.client.screen.BaseContainerScreen;
import committee.nova.mods.avaritia.common.menu.InfinityClockMenu;
import committee.nova.mods.avaritia.common.net.C2SSetTimePacket;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class InfinityClockScreen
extends BaseContainerScreen<InfinityClockMenu> {
    private int guiLeft;
    private int guiTop;
    private final int imageWidth = 176;
    private final int imageHeight = 166;
    private EditBox timeInput;

    public InfinityClockScreen(InfinityClockMenu container, Inventory inventory, Component title) {
        super(container, inventory, title, Res.INFINITY_CLOCK_TIME_TEX, 176, 166);
    }

    @Override
    protected void subInit() {
        super.subInit();
        this.guiLeft = (this.width - 176) / 2;
        this.guiTop = (this.height - 166) / 2;
        int buttonW = 22;
        int buttonH = 24;
        int spacing = 2;
        int startX = this.guiLeft + 17;
        int startY = this.guiTop + 22;
        this.addRenderableWidget((GuiEventListener)new TimeButton(startX + (buttonW + spacing) * 0, startY, 17, 22, 0, 0));
        this.addRenderableWidget((GuiEventListener)new TimeButton(startX + (buttonW + spacing) * 1, startY, 41, 22, 1, 6000));
        this.addRenderableWidget((GuiEventListener)new TimeButton(startX + (buttonW + spacing) * 2, startY, 65, 22, 2, 12000));
        this.addRenderableWidget((GuiEventListener)new TimeButton(startX + (buttonW + spacing) * 3, startY, 89, 22, 3, 14000));
        this.addRenderableWidget((GuiEventListener)new TimeButton(startX + (buttonW + spacing) * 4, startY, 113, 22, 4, 18000));
        this.addRenderableWidget((GuiEventListener)new TimeButton(startX + (buttonW + spacing) * 5, startY, 137, 22, 5, 22000));
        this.titleLabelX = 62;
        this.timeInput = new EditBox(this.font, this.guiLeft + 38, this.guiTop + 52, 113, 10, (Component)Component.literal((String)""));
        this.timeInput.setMaxLength(10);
        this.addRenderableWidget((GuiEventListener)this.timeInput);
    }

    @Override
    protected void renderBgs(GuiGraphics pGuiGraphics, float pPartialTick, int pX, int pY) {
        this.timeInput.render(pGuiGraphics, pX, pY, pPartialTick);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.timeInput.isFocused() && keyCode == 257) {
            try {
                int time = Integer.parseInt(this.timeInput.getValue());
                NetworkHandler.CHANNEL.sendToServer((Object)new C2SSetTimePacket(time));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    static class TimeButton
    extends AbstractWidget {
        private final int texU;
        private final int texV;
        private final int index;
        private final int timeValue;
        private final int w = 22;
        private final int h = 24;

        public TimeButton(int x, int y, int texU, int texV, int index, int timeValue) {
            super(x, y, 22, 24, (Component)Component.empty());
            this.texU = texU;
            this.texV = texV;
            this.index = index;
            this.timeValue = timeValue;
        }

        protected void renderWidget(GuiGraphics g, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)Res.INFINITY_CLOCK_TIME_TEX);
            if (this.isHovered) {
                int hoverU = 177 + this.index % 2 * 23;
                int hoverV = 1 + this.index / 2 * 25;
                g.blit(Res.INFINITY_CLOCK_TIME_TEX, this.getX(), this.getY(), hoverU, hoverV, 22, 24);
            } else {
                g.blit(Res.INFINITY_CLOCK_TIME_TEX, this.getX(), this.getY(), this.texU, this.texV, 22, 24);
            }
        }

        public void onClick(double mouseX, double mouseY) {
            NetworkHandler.CHANNEL.sendToServer((Object)new C2SSetTimePacket(this.timeValue));
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput output) {
            this.defaultButtonNarrationText(output);
        }
    }
}

