/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen.side;

import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.api.iface.ITileIO;
import committee.nova.mods.avaritia.client.screen.side.SideButton;
import committee.nova.mods.avaritia.core.io.SideConfiguration;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class SideConfigScreen
extends Screen {
    private SideConfiguration sideConfig;
    private final Screen parentScreen;
    private final BlockPos blockPos;
    private final ITileIO tile;
    private int guiLeft;
    private int guiTop;
    private int imageWidth = 156;
    private int imageHeight = 117;
    private SideButton northButton;
    private SideButton southButton;
    private SideButton eastButton;
    private SideButton westButton;
    private SideButton upButton;
    private SideButton downButton;

    public SideConfigScreen(Screen parentScreen, SideConfiguration sideConfig, BlockPos blockPos, ITileIO tile) {
        super((Component)Component.translatable((String)"screen.avaritia.side_config.title"));
        this.parentScreen = parentScreen;
        this.sideConfig = new SideConfiguration(sideConfig);
        this.blockPos = blockPos;
        this.tile = tile;
    }

    protected void init() {
        super.init();
        this.guiLeft = (this.width - this.imageWidth) / 2;
        this.guiTop = (this.height - this.imageHeight) / 2;
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.createSideButtons(x, y);
        this.addRenderableWidget((GuiEventListener)new ImageButton(x + 135, y + 93, 17, 18, 17, 164, 18, Res.SIDE_CONFIG_TEX, button -> this.setAllSides(SideConfiguration.SideMode.OFF)));
        this.addRenderableWidget((GuiEventListener)new ImageButton(x + 4, y + 4, 17, 18, 0, 164, 18, Res.SIDE_CONFIG_TEX, button -> this.onClose()));
    }

    private void createSideButtons(int x, int y) {
        int centerX = x + 67;
        int centerY = y + 50;
        this.upButton = new SideButton(centerX, centerY - 24, Direction.UP, this.sideConfig.getSideMode(Direction.UP), this);
        this.addRenderableWidget((GuiEventListener)this.upButton);
        this.downButton = new SideButton(centerX, centerY + 24, Direction.DOWN, this.sideConfig.getSideMode(Direction.DOWN), this);
        this.addRenderableWidget((GuiEventListener)this.downButton);
        this.northButton = new SideButton(centerX, centerY, Direction.NORTH, this.sideConfig.getSideMode(Direction.NORTH), this);
        this.addRenderableWidget((GuiEventListener)this.northButton);
        this.southButton = new SideButton(centerX - 23, centerY + 24, Direction.SOUTH, this.sideConfig.getSideMode(Direction.SOUTH), this);
        this.addRenderableWidget((GuiEventListener)this.southButton);
        this.westButton = new SideButton(centerX - 23, centerY, Direction.WEST, this.sideConfig.getSideMode(Direction.WEST), this);
        this.addRenderableWidget((GuiEventListener)this.westButton);
        this.eastButton = new SideButton(centerX + 23, centerY, Direction.EAST, this.sideConfig.getSideMode(Direction.EAST), this);
        this.addRenderableWidget((GuiEventListener)this.eastButton);
    }

    public void cycleModeForDirection(Direction direction) {
        this.tile.cycleSideModeForNeutronCollector(direction);
        this.sideConfig.setSideMode(direction, this.tile.getSideConfiguration().getSideMode(direction));
    }

    private void setAllSides(SideConfiguration.SideMode mode) {
        for (Direction direction : Direction.values()) {
            this.sideConfig.setSideMode(direction, mode);
            this.tile.cycleSideModeForNeutronCollector(direction);
        }
        this.updateAllButtons();
        this.sendConfigUpdate();
    }

    public void updateAllButtons() {
        this.northButton.updateMode(this.sideConfig.getSideMode(Direction.NORTH));
        this.southButton.updateMode(this.sideConfig.getSideMode(Direction.SOUTH));
        this.eastButton.updateMode(this.sideConfig.getSideMode(Direction.EAST));
        this.westButton.updateMode(this.sideConfig.getSideMode(Direction.WEST));
        this.upButton.updateMode(this.sideConfig.getSideMode(Direction.UP));
        this.downButton.updateMode(this.sideConfig.getSideMode(Direction.DOWN));
    }

    public void sendConfigUpdate() {
        NetworkHandler.sendSideConfigUpdate(this.blockPos, this.sideConfig);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        guiGraphics.blit(Res.SIDE_CONFIG_TEX, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
    }

    @Generated
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Generated
    public int getGuiTop() {
        return this.guiTop;
    }
}

