/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.block.craft;

import committee.nova.mods.avaritia.api.common.block.BaseTileEntityBlock;
import committee.nova.mods.avaritia.common.tile.TierCraftTile;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.enums.ModCraftTier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TierCraftTableBlock
extends BaseTileEntityBlock {
    ModCraftTier tier;

    public TierCraftTableBlock(ModCraftTier tier) {
        super(MapColor.METAL, tier.sound, (float)tier.hardness, (float)tier.resistance, true);
        this.tier = tier;
    }

    @NotNull
    public InteractionResult use(@NotNull BlockState pState, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand p_60507_, @NotNull BlockHitResult p_60508_) {
        if (!level.isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity tile = level.getBlockEntity(pos);
            if (tile instanceof TierCraftTile) {
                TierCraftTile table = (TierCraftTile)tile;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)table, (BlockPos)pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (state.getBlock() != newState.getBlock() && (tile = level.getBlockEntity(pos)) instanceof TierCraftTile) {
            TierCraftTile table = (TierCraftTile)tile;
            Containers.dropContents((Level)level, (BlockPos)pos, table.getInventory().getStacks());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TierCraftTile(pos, state);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = pos.relative(direction);
            if (!level.getBlockState(offsetPos).is((Block)ModBlocks.infinity.get())) continue;
            return 15;
        }
        return this.tier.lightLevel;
    }
}

