/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.capability;

import committee.nova.mods.avaritia.api.common.wrapper.ItemStackWrapper;
import committee.nova.mods.avaritia.common.item.misc.NeutronRingItem;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class RingStorageProvider
implements ICapabilitySerializable<CompoundTag> {
    private final ItemStackWrapper inv = new ItemStackWrapper(81, Integer.MAX_VALUE);
    private final LazyOptional<ItemStackWrapper> inventoryCap;

    public RingStorageProvider(ItemStack stack, CompoundTag nbt) {
        this.inv.setSlotValidator((slot, stack2) -> !(stack2.getItem() instanceof NeutronRingItem));
        this.inventoryCap = LazyOptional.of(() -> this.inv);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.inv.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.inv.deserializeNBT(nbt);
    }
}

