/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.common.crafting.recipe.ITierCraftingRecipe;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import java.util.ArrayList;
import java.util.function.BiFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class ShapelessTableCraftingRecipe
implements ITierCraftingRecipe {
    public final NonNullList<Ingredient> inputs;
    private final ResourceLocation recipeId;
    private final ItemStack output;
    private final int tier;
    private BiFunction<Integer, ItemStack, ItemStack> transformers;

    public ShapelessTableCraftingRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, ItemStack output) {
        this(recipeId, inputs, output, 0);
    }

    public ShapelessTableCraftingRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, ItemStack output, int tier) {
        this.recipeId = recipeId;
        this.inputs = inputs;
        this.output = output;
        this.tier = tier;
    }

    private static int getTierFromSize(int size) {
        return size < 10 ? 1 : (size < 26 ? 2 : (size < 50 ? 3 : 4));
    }

    @NotNull
    public ItemStack getResultItem(@NotNull RegistryAccess p_267052_) {
        return this.output;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    @NotNull
    public ResourceLocation getId() {
        return this.recipeId;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.SHAPELESS_CRAFT_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.CRAFTING_TABLE_RECIPE.get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.inputs.size();
    }

    @Override
    public ItemStack assemble(IItemHandler inventory) {
        return this.output.copy();
    }

    @Override
    @NotNull
    public ItemStack assemble(@NotNull Container inv, @NotNull RegistryAccess p_267052_) {
        return this.output.copy();
    }

    @Override
    public boolean matches(IItemHandler inventory) {
        if (this.tier != 0 && this.tier != ShapelessTableCraftingRecipe.getTierFromSize(inventory.getSlots())) {
            return false;
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int matched = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            inputs.add(stack);
            ++matched;
        }
        return matched == this.inputs.size() && RecipeMatcher.findMatches(inputs, this.inputs) != null;
    }

    @Override
    public boolean matches(@NotNull Container inv, @NotNull Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull IItemHandler inv) {
        NonNullList<ItemStack> remaining = ITierCraftingRecipe.super.getRemainingItems(inv);
        if (this.transformers != null) {
            boolean[] used = new boolean[remaining.size()];
            block0: for (int i = 0; i < remaining.size(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                for (int j = 0; j < this.inputs.size(); ++j) {
                    Ingredient input = (Ingredient)this.inputs.get(j);
                    if (used[j] || !input.test(stack)) continue;
                    ItemStack ingredient = this.transformers.apply(j, stack);
                    used[j] = true;
                    remaining.set(i, (Object)ingredient);
                    continue block0;
                }
            }
        }
        return remaining;
    }

    @Override
    public int getTier() {
        if (this.tier > 0) {
            return this.tier;
        }
        return ShapelessTableCraftingRecipe.getTierFromSize(this.inputs.size());
    }

    @Override
    public boolean hasRequiredTier() {
        return this.tier > 0;
    }

    public void setTransformers(BiFunction<Integer, ItemStack, ItemStack> transformers) {
        this.transformers = transformers;
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessTableCraftingRecipe> {
        @NotNull
        public ShapelessTableCraftingRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            NonNullList inputs = NonNullList.create();
            JsonArray ingredients = GsonHelper.getAsJsonArray((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.fromJson((JsonElement)ingredients.get(i)));
            }
            ItemStack output = ShapedRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"result"));
            int tier = GsonHelper.getAsInt((JsonObject)json, (String)"tier", (int)0);
            return new ShapelessTableCraftingRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, tier);
        }

        public ShapelessTableCraftingRecipe fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int size = buffer.readVarInt();
            NonNullList inputs = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.fromNetwork((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.readItem();
            int tier = buffer.readVarInt();
            return new ShapelessTableCraftingRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, tier);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapelessTableCraftingRecipe recipe) {
            buffer.writeVarInt(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.toNetwork(buffer);
            }
            buffer.writeItem(recipe.output);
            buffer.writeVarInt(recipe.tier);
        }
    }
}

