/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity.ball;

import committee.nova.mods.avaritia.client.particle.ShockwaveParticleOptions;
import committee.nova.mods.avaritia.init.registry.ModMobEffects;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class BurningBallEntity
extends ThrowableProjectile {
    public BurningBallEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void onHit(@NotNull HitResult result) {
        super.onHit(result);
        this.discard();
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        super.onHitBlock(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity owner = this.getOwner();
            BlockPos pos = result.getBlockPos();
            if (owner instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)owner;
                List entities = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(pos.offset(-10, -10, -10), pos.offset(10, 10, 10)), livingEntity -> !livingEntity.isSpectator() && livingEntity.isAlive() && !livingEntity.equals((Object)player));
                entities.forEach(entity -> entity.addEffect(new MobEffectInstance((MobEffect)ModMobEffects.BURNING.get(), 600, 3)));
                BurningBallEntity.spawnParticles((Level)serverLevel, (ParticleOptions)new ShockwaveParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 10.0f, true, "minecraft:flame"), this.getX(), this.getY(), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0, true);
            }
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity owner = this.getOwner();
            BlockPos pos = result.getEntity().blockPosition();
            if (owner instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)owner;
                List entities = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(pos.offset(-10, -10, -10), pos.offset(10, 10, 10)), livingEntity -> !livingEntity.isSpectator() && livingEntity.isAlive() && !livingEntity.equals((Object)player));
                entities.forEach(entity -> entity.addEffect(new MobEffectInstance((MobEffect)ModMobEffects.BURNING.get(), 600, 3)));
                BurningBallEntity.spawnParticles((Level)serverLevel, (ParticleOptions)new ShockwaveParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 10.0f, true, "minecraft:flame"), this.getX(), this.getY(), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0, true);
            }
        }
    }

    public static void spawnParticles(Level level, ParticleOptions particle, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed, boolean force) {
        level.getServer().getPlayerList().getPlayers().forEach(player -> ((ServerLevel)level).sendParticles(player, particle, force, x, y, z, count, deltaX, deltaY, deltaZ, speed));
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean ignoreExplosion() {
        return true;
    }

    protected void defineSynchedData() {
    }
}

