/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.misc;

import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.iface.IToolTransform;
import committee.nova.mods.avaritia.common.entity.RainProEntity;
import committee.nova.mods.avaritia.common.entity.StormProEntity;
import committee.nova.mods.avaritia.common.entity.SunProEntity;
import committee.nova.mods.avaritia.common.item.resources.ResourceItem;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import java.util.Arrays;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class InfinityUmbrellaItem
extends ResourceItem
implements ISwitchable,
IToolTransform {
    public static final List<String> MODES = Arrays.asList("infinity_umbrella_normal", "infinity_umbrella_sun", "infinity_umbrella_rain", "infinity_umbrella_storm");
    private static final int MODE_NORMAL = 0;
    private static final int MODE_SUN = 1;
    private static final int MODE_RAIN = 2;
    private static final int MODE_STORM = 3;
    private static final int MIN_DURATION = 12000;
    private static final int MAX_DURATION = 24000;

    public InfinityUmbrellaItem() {
        super(ModRarities.COSMIC, true, new Item.Properties().stacksTo(1));
    }

    private int getRandomDuration(Level level) {
        return 12000 + level.random.nextInt(12001);
    }

    private void onUse(Level level, Player player, ItemStack stack, @NotNull InteractionHand hand) {
        if (!level.isClientSide) {
            float pitch = player.getXRot();
            int currentMode = ISwitchable.getCurrentMode(stack, MODES);
            int duration = this.getRandomDuration(level);
            switch (currentMode) {
                case 0: {
                    break;
                }
                case 1: {
                    SunProEntity sunProEntity = (SunProEntity)((EntityType)ModEntities.SUN_PRO.get()).create(level);
                    if (pitch <= -85.0f) {
                        if (!level.getLevelData().isRaining() && level.getLevelData().isThundering()) break;
                        level.getLevelData().setRaining(false);
                        break;
                    }
                    if (sunProEntity == null) break;
                    sunProEntity.setOwner((Entity)player);
                    sunProEntity.setPos(player.getX(), player.getEyeY() + 0.1, player.getZ());
                    sunProEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
                    level.addFreshEntity((Entity)sunProEntity);
                    level.playSound(player, player.getOnPos(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
                    break;
                }
                case 2: {
                    RainProEntity rainProEntity = (RainProEntity)((EntityType)ModEntities.RAIN_PRO.get()).create(level);
                    if (pitch <= -85.0f && level instanceof ServerLevel) {
                        ServerLevel server = (ServerLevel)level;
                        level.getLevelData().setRaining(true);
                        server.setWeatherParameters(0, duration, true, false);
                        break;
                    }
                    if (rainProEntity == null) break;
                    rainProEntity.setOwner((Entity)player);
                    rainProEntity.setPos(player.getX(), player.getEyeY() + 0.1, player.getZ());
                    rainProEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
                    level.addFreshEntity((Entity)rainProEntity);
                    break;
                }
                case 3: {
                    StormProEntity stormProEntity = (StormProEntity)((EntityType)ModEntities.STORM_PRO.get()).create(level);
                    if (pitch <= -85.0f && level instanceof ServerLevel) {
                        ServerLevel server = (ServerLevel)level;
                        level.getLevelData().setRaining(true);
                        server.setWeatherParameters(0, duration, true, true);
                        break;
                    }
                    if (stormProEntity == null) break;
                    stormProEntity.setOwner((Entity)player);
                    stormProEntity.setPos(player.getX(), player.getEyeY() + 0.1, player.getZ());
                    stormProEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
                    level.addFreshEntity((Entity)stormProEntity);
                }
            }
            player.swing(hand, true);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            this.cycleMode(world, player, hand, MODES);
            return InteractionResultHolder.success((Object)stack);
        }
        this.onUse(world, player, stack, hand);
        return super.use(world, player, hand);
    }

    public void inventoryTick(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (!pLevel.isClientSide && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (pIsSelected) {
                player.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, -1, 0, false, false));
            } else {
                player.removeEffect(MobEffects.SLOW_FALLING);
            }
        }
    }
}

