/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.misc;

import committee.nova.mods.avaritia.api.iface.ITileIO;
import committee.nova.mods.avaritia.core.io.SideConfiguration;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SideConfigurationCardItem
extends Item {
    public SideConfigurationCardItem() {
        super(new Item.Properties().stacksTo(1).rarity(ModRarities.RARE));
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, level, tooltip, flag);
        if (stack.hasTag() && stack.getTag().contains("SideConfig")) {
            tooltip.add((Component)Component.translatable((String)"tooltip.avaritia.side_config_card.has_config"));
            tooltip.add((Component)Component.translatable((String)"tooltip.avaritia.side_config_card.instruction_right_click"));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.avaritia.side_config_card.no_config"));
            tooltip.add((Component)Component.translatable((String)"tooltip.avaritia.side_config_card.instruction_shift_right_click"));
        }
        tooltip.add((Component)Component.translatable((String)"tooltip.avaritia.side_config_card.instruction_shift_air"));
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        Player player = ctx.getPlayer();
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        if (player == null || level.isClientSide()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (player.isShiftKeyDown()) {
            if (blockEntity instanceof ITileIO) {
                ITileIO tileIO = (ITileIO)blockEntity;
                if (!stack.getOrCreateTag().contains("SideConfig")) {
                    SideConfiguration config = tileIO.getSideConfiguration();
                    this.saveConfigToItem(stack, config);
                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.avaritia.side_config_card.read_success"), true);
                    return InteractionResult.SUCCESS;
                }
                SideConfiguration config = this.loadConfigFromItem(stack);
                tileIO.setSideConfiguration(config);
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.avaritia.side_config_card.apply_success"), true);
                return InteractionResult.SUCCESS;
            }
            if (stack.hasTag()) {
                if (stack.getTag().contains("SideConfig")) {
                    stack.getTag().remove("SideConfig");
                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.avaritia.side_config_card.cleared"), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.avaritia.side_config_card.already_empty"), true);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void saveConfigToItem(ItemStack stack, SideConfiguration config) {
        stack.getOrCreateTag().put("SideConfig", (Tag)config.toNBT());
    }

    private SideConfiguration loadConfigFromItem(ItemStack stack) {
        if (!stack.hasTag() || !stack.getTag().contains("SideConfig")) {
            return new SideConfiguration();
        }
        return SideConfiguration.fromNBT(stack.getTag().getCompound("SideConfig"));
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return stack.hasTag() && stack.getTag().contains("SideConfig");
    }
}

