/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools;

import committee.nova.mods.avaritia.api.iface.IUndamageable;
import committee.nova.mods.avaritia.api.util.lang.TextUtils;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.registry.ModArmorMaterial;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityArmorItem
extends ArmorItem
implements IUndamageable {
    public InfinityArmorItem(ArmorItem.Type pSlot) {
        super(ModArmorMaterial.INFINITY_ARMOR, pSlot, new Item.Properties().rarity(ModRarities.COSMIC).fireResistant().stacksTo(1));
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean isEnderMask(ItemStack stack, Player player, EnderMan enderMan) {
        return true;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> tooltip, @NotNull TooltipFlag pIsAdvanced) {
        if (this.type.getSlot() == EquipmentSlot.HEAD) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "+" + String.valueOf(ChatFormatting.ITALIC) + TextUtils.makeSANIC(I18n.get((String)"tooltip.infinity", (Object[])new Object[0])) + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.BLUE) + "% ")).append(I18n.get((String)"effect.minecraft.night_vision", (Object[])new Object[0])));
        }
        if (this.type.getSlot() == EquipmentSlot.CHEST) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "+" + String.valueOf(ChatFormatting.ITALIC) + TextUtils.makeSANIC(I18n.get((String)"tooltip.infinity", (Object[])new Object[0])) + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.BLUE) + "% ")).append(I18n.get((String)"attribute.name.generic.flying_speed", (Object[])new Object[0])));
        }
        if (this.type.getSlot() == EquipmentSlot.LEGS) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "+" + String.valueOf(ChatFormatting.ITALIC) + TextUtils.makeSANIC(I18n.get((String)"tooltip.infinity", (Object[])new Object[0])) + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.BLUE) + "% ")).append(I18n.get((String)"attribute.name.generic.walking_speed", (Object[])new Object[0])));
        }
        if (this.type.getSlot() == EquipmentSlot.FEET) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "+" + String.valueOf(ChatFormatting.ITALIC) + TextUtils.makeSANIC(I18n.get((String)"tooltip.infinity", (Object[])new Object[0])) + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.BLUE) + "% ")).append(I18n.get((String)"attribute.name.generic.movement_speed", (Object[])new Object[0])));
        }
        super.appendHoverText(pStack, pLevel, tooltip, pIsAdvanced);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(Level level, Entity location, ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.getX(), location.getY(), location.getZ(), stack);
    }
}

