/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.crystal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import committee.nova.mods.avaritia.api.iface.ITooltip;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public class CrystalHoeItem
extends HoeItem
implements ITooltip {
    public CrystalHoeItem() {
        super(ModToolTiers.CRYSTAL, 0, -25.0f, new Item.Properties().rarity(ModRarities.EPIC).stacksTo(1).fireResistant());
    }

    @Override
    public boolean hasDescTooltip() {
        return true;
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        return super.use(world, player, hand);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Block targetBlock = world.getBlockState(blockpos).getBlock();
        Player player = context.getPlayer();
        BlockState blockstate = (BlockState)Blocks.FARMLAND.defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(7));
        int range = 1;
        BlockPos minPos = blockpos.offset(-range, 0, -range);
        BlockPos maxPos = blockpos.offset(range, 0, range);
        if (context.getClickedFace() != Direction.DOWN && world.isEmptyBlock(blockpos.above()) && (targetBlock instanceof GrassBlock || targetBlock.equals(Blocks.DIRT) || targetBlock.equals(Blocks.COARSE_DIRT))) {
            if (player != null && !world.isClientSide) {
                Iterable boxMutable = BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos);
                for (BlockPos pos : boxMutable) {
                    Block block = world.getBlockState(pos).getBlock();
                    if (!world.isEmptyBlock(pos.above()) || !(block instanceof GrassBlock) && !block.equals(Blocks.DIRT) && !block.equals(Blocks.COARSE_DIRT)) continue;
                    world.setBlock(pos, blockstate, 11);
                }
            }
            world.playSound(player, blockpos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        BlockState targetState = world.getBlockState(blockpos);
        if (world instanceof ServerLevel) {
            BonemealableBlock growable;
            ServerLevel serverLevel = (ServerLevel)world;
            if (targetBlock instanceof BonemealableBlock && (growable = (BonemealableBlock)targetBlock).isValidBonemealTarget((LevelReader)serverLevel, blockpos, targetState, false) && ForgeHooks.onCropsGrowPre((Level)serverLevel, (BlockPos)blockpos, (BlockState)targetState, (boolean)true)) {
                growable.performBonemeal(serverLevel, world.random, blockpos, targetState);
                serverLevel.levelEvent(2005, blockpos, 0);
                ForgeHooks.onCropsGrowPost((Level)serverLevel, (BlockPos)blockpos, (BlockState)targetState);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.resetAttackStrengthTicker();
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Weapon modifier", (double)this.getTier().getAttackDamageBonus(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Weapon modifier", (double)this.getTier().getSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

