/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.menu;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.common.slot.FakeSlot;
import committee.nova.mods.avaritia.common.net.chest.C2SInfinityChestActionPack;
import committee.nova.mods.avaritia.common.tile.InfinityChestTile;
import committee.nova.mods.avaritia.core.chest.ChestHandler;
import committee.nova.mods.avaritia.core.chest.ClientChestManager;
import committee.nova.mods.avaritia.core.chest.InfinityChestContainer;
import committee.nova.mods.avaritia.core.chest.ServerChestHandler;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.init.registry.ModMenus;
import committee.nova.mods.avaritia.util.StorageUtils;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class InfinityChestMenu
extends AbstractContainerMenu {
    public static final int CONTAINER_SLOT_START = 36;
    public static final int CONTAINER_SLOT_SIZE = 135;
    public final ChestHandler chest;
    public final Player player;
    public final Level level;
    public final BlockPos blockPos;
    public InfinityChestTile chestTile;
    public InfinityChestContainer chestContainer = new InfinityChestContainer(this);
    public boolean LShifting = false;
    public final UUID owner;
    public boolean locked;
    public String filter;
    public byte sortType;
    public UUID channelID;

    public InfinityChestMenu(int containerId, Inventory playerInv, FriendlyByteBuf extraData) {
        super((MenuType)ModMenus.infinity_chest.get(), containerId);
        this.player = playerInv.player;
        this.level = playerInv.player.level();
        this.blockPos = extraData.readBlockPos();
        this.owner = extraData.readUUID();
        this.locked = extraData.readBoolean();
        this.filter = extraData.readUtf(64);
        this.sortType = extraData.readByte();
        this.channelID = extraData.readUUID();
        this.addSlots(playerInv.player, playerInv);
        this.chestContainer = new InfinityChestContainer(this);
        this.chest = ClientChestManager.getInstance().getChest(this.chestContainer);
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 15; ++j) {
                this.addSlot(new FakeSlot((Container)this.chestContainer, i * 15 + j, 8 + j * 18, 16 + i * 18){

                    public ItemStack getItem() {
                        ItemStack itemStack = super.getItem();
                        itemStack.setCount(1);
                        return itemStack;
                    }
                });
            }
        }
    }

    public InfinityChestMenu(int containerId, Player player, InfinityChestTile blockEntity) {
        super((MenuType)ModMenus.infinity_chest.get(), containerId);
        this.player = player;
        this.level = player.level();
        this.blockPos = blockEntity.getBlockPos();
        this.chestTile = blockEntity;
        this.owner = blockEntity.getOwner() == null ? player.getUUID() : blockEntity.getOwner();
        this.locked = blockEntity.isLocked();
        this.filter = blockEntity.getFilter();
        this.sortType = blockEntity.getSortType();
        this.channelID = blockEntity.getChannelID();
        this.chest = blockEntity.getChannel();
        if (!this.chest.isRemoved()) {
            ((ServerChestHandler)this.chest).addListener((ServerPlayer)player);
        }
        this.addSlots(player, player.getInventory());
    }

    private void addSlots(Player player, Inventory playerInv) {
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInv, l, 62 + l * 18, 250));
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInv, i1 + k * 9 + 9, 62 + i1 * 18, 192 + k * 18));
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean clickMenuButton(Player pPlayer, int pId) {
        switch (pId) {
            case 0: {
                if (!this.owner.equals(this.player.getUUID())) break;
                this.locked = !this.locked;
                this.chestTile.setLocked(this.locked);
                if (!this.locked) break;
                this.saveBlock();
                break;
            }
            case 1: {
                this.nextSort();
                break;
            }
            case 2: {
                this.reverseSort();
            }
        }
        return pId < 3;
    }

    public void action(int actionId, String id) {
        switch (actionId) {
            case 0: {
                this.onLeftClickDummySlot(id);
                break;
            }
            case 1: {
                this.onRightClickDummySlot(id);
                break;
            }
            case 2: {
                this.onLeftShiftDummySlot(id);
                break;
            }
            case 3: {
                this.onRightShiftDummySlot(id);
                break;
            }
            case 4: {
                this.tryThrowOneFromDummySlot(id);
                break;
            }
            case 5: {
                this.tryThrowStickFromDummySlot(id);
                break;
            }
            case 6: {
                this.onLeftDragDummySlot(id);
                break;
            }
            case 7: {
                this.onRightDragDummySlot(id);
                break;
            }
            case 8: {
                this.onCloneFormDummySlot(id);
                break;
            }
            case 9: {
                this.onDragCloneDummySlot(id);
            }
        }
    }

    public void onLeftClickDummySlot(String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            if (id.equals("minecraft:air")) {
                return;
            }
            this.setCarried(this.chest.saveTakeItem(id, false));
        } else {
            if (carried.getCount() > 1) {
                this.chest.addItem(carried);
                return;
            }
            AtomicBoolean canal = new AtomicBoolean(false);
            carried.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                if (!this.chest.storageItems.containsKey(id)) {
                    return;
                }
                int slots = iItemHandler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    ItemStack remainingItem;
                    int remainingSlotSpace;
                    ItemStack tryInsertItem = new ItemStack((ItemLike)StorageUtils.getItem(id));
                    if (!ItemStack.isSameItemSameTags((ItemStack)tryInsertItem, (ItemStack)iItemHandler.getStackInSlot(i)) && !iItemHandler.getStackInSlot(i).isEmpty() || (remainingSlotSpace = iItemHandler.getSlotLimit(i) - iItemHandler.getStackInSlot(i).getCount()) <= 0) continue;
                    int transmitAmount = (int)Math.min(Integer.MAX_VALUE, this.chest.storageItems.get(id) / 2L);
                    transmitAmount = Math.max(transmitAmount, 64000);
                    transmitAmount = (int)Math.min((long)transmitAmount, this.chest.storageItems.get(id));
                    int markAmount = transmitAmount = Math.min(transmitAmount, remainingSlotSpace);
                    tryInsertItem.setCount(transmitAmount);
                    for (int j = 0; j < 64 && (transmitAmount = (remainingItem = iItemHandler.insertItem(i, tryInsertItem, false)).getCount()) > 0; ++j) {
                        tryInsertItem.setCount(transmitAmount);
                    }
                    if ((markAmount -= transmitAmount) <= 0) continue;
                    this.chest.takeItem(id, markAmount);
                    canal.set(true);
                    return;
                }
            });
            if (canal.get()) {
                return;
            }
            this.chest.addItem(carried);
        }
    }

    public void onRightClickDummySlot(String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            if (id.equals("minecraft:air")) {
                return;
            }
            this.setCarried(this.chest.saveTakeItem(id, true));
        } else {
            if (carried.getCount() > 1) {
                this.chest.fillItemStack(carried, -1);
                return;
            }
            AtomicBoolean canal = new AtomicBoolean(false);
            carried.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                int slots = iItemHandler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    int maxExtractAmount;
                    ItemStack itemStack = iItemHandler.getStackInSlot(i);
                    if (itemStack.isEmpty() || itemStack.hasTag() || (itemStack = iItemHandler.extractItem(i, maxExtractAmount = this.chest.canStorageAmount(itemStack), false)).isEmpty()) continue;
                    this.chest.addItem(itemStack);
                    canal.set(true);
                    break;
                }
            });
            if (canal.get()) {
                return;
            }
            this.chest.addItem(carried);
        }
    }

    public void onLeftShiftDummySlot(String id) {
        if (id.equals("minecraft:air")) {
            return;
        }
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            if (!this.chest.storageItems.containsKey(id)) {
                return;
            }
            ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(id));
            itemStack.setCount((int)Math.min((long)itemStack.getMaxStackSize(), this.chest.storageItems.get(id)));
            int i = itemStack.getCount();
            this.moveItemStackTo(itemStack, 41, 50, false);
            if ((i -= itemStack.getCount()) > 0) {
                itemStack.setCount(i);
                this.chest.removeItem(itemStack);
            }
        } else {
            if (carried.getCount() > 1) {
                this.chest.fillItemStack(carried, -1);
                return;
            }
            AtomicBoolean canal = new AtomicBoolean(false);
            carried.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                if (!this.chest.storageItems.containsKey(id)) {
                    return;
                }
                int transmitAmount = (int)Math.min(Integer.MAX_VALUE, this.chest.storageItems.get(id) / 2L);
                transmitAmount = Math.max(transmitAmount, 64000);
                int markAmount = transmitAmount = (int)Math.min((long)transmitAmount, this.chest.storageItems.get(id));
                ItemStack tryInsertItem = new ItemStack((ItemLike)StorageUtils.getItem(id), transmitAmount);
                int slots = iItemHandler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    ItemStack remainingItem;
                    for (int j = 0; j < 64 && (remainingItem = iItemHandler.insertItem(i, tryInsertItem, false)).getCount() != transmitAmount && (transmitAmount = remainingItem.getCount()) > 0; ++j) {
                        tryInsertItem.setCount(transmitAmount);
                    }
                }
                if ((markAmount -= transmitAmount) > 0) {
                    this.chest.takeItem(id, markAmount);
                    canal.set(true);
                }
            });
            if (canal.get()) {
                return;
            }
            this.chest.addItem(carried);
        }
    }

    public void onRightShiftDummySlot(String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            if (id.equals("minecraft:air")) {
                return;
            }
            if (!this.chest.storageItems.containsKey(id)) {
                return;
            }
            ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(id));
            this.moveItemStackTo(itemStack, 41, 50, false);
            if (itemStack.isEmpty()) {
                this.chest.takeItem(id, 1);
            }
        } else {
            if (carried.getCount() > 1) {
                this.chest.fillItemStack(carried, -1);
                return;
            }
            AtomicBoolean canal = new AtomicBoolean(false);
            carried.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                int slots = iItemHandler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    int maxExtractAmount;
                    ItemStack itemStack = iItemHandler.getStackInSlot(i);
                    if (itemStack.isEmpty() || itemStack.hasTag() || (itemStack = iItemHandler.extractItem(i, maxExtractAmount = this.chest.canStorageAmount(itemStack), false)).isEmpty()) continue;
                    this.chest.addItem(itemStack);
                    canal.set(true);
                }
            });
            if (canal.get()) {
                return;
            }
            this.chest.addItem(carried);
        }
    }

    public void tryThrowOneFromDummySlot(String id) {
        if (id.equals("minecraft:air")) {
            return;
        }
        if (!this.chest.storageItems.containsKey(id)) {
            return;
        }
        ItemStack itemStack = this.chest.takeItem(id, 1);
        this.player.drop(itemStack, false);
    }

    public void tryThrowStickFromDummySlot(String id) {
        if (id.equals("minecraft:air")) {
            return;
        }
        if (!this.chest.storageItems.containsKey(id)) {
            return;
        }
        ItemStack itemStack = this.chest.saveTakeItem(id, false);
        this.player.drop(itemStack, false);
    }

    public void onLeftDragDummySlot(String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            return;
        }
        this.chest.addItem(carried);
    }

    public void onRightDragDummySlot(String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            return;
        }
        this.chest.fillItemStack(carried, -1);
    }

    public void onCloneFormDummySlot(String id) {
        if (id.equals("minecraft:air") || !this.player.isCreative()) {
            return;
        }
        this.chest.addItem(id, Long.max(this.chest.getRealItemAmount(id), 64L));
    }

    public void onDragCloneDummySlot(String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            return;
        }
        ItemStack itemStack = carried.copy();
        itemStack.setCount(itemStack.getMaxStackSize());
        this.chest.addItem(itemStack);
    }

    public void nextSort() {
        this.sortType = (byte)(this.sortType + 2);
        if (this.sortType > 7) {
            this.sortType = (byte)(this.sortType % 8);
        }
        if (this.level.isClientSide) {
            this.chestContainer.refreshContainer(true);
        }
    }

    public void reverseSort() {
        this.sortType = this.sortType % 2 == 0 ? (byte)(this.sortType + 1) : (byte)(this.sortType - 1);
        if (this.level.isClientSide) {
            this.chestContainer.refreshContainer(true);
        }
    }

    private void saveBlock() {
        this.chestTile.setFilter(this.filter);
        this.chestTile.setSortType(this.sortType);
    }

    @ParametersAreNonnullByDefault
    public void clicked(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        if (pSlotId >= 36) {
            String object = pSlotId - 36 < this.chestContainer.viewingObject.size() ? this.chestContainer.viewingObject.get(pSlotId - 36) : "minecraft:air";
            block0 : switch (pButton) {
                case 0: {
                    switch (pClickType) {
                        case QUICK_MOVE: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 2, object));
                            this.onLeftShiftDummySlot(object);
                            break block0;
                        }
                        case PICKUP: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 0, object));
                            this.onLeftClickDummySlot(object);
                            break block0;
                        }
                        case THROW: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 4, object));
                            this.tryThrowOneFromDummySlot(object);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (pClickType) {
                        case PICKUP: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 1, object));
                            this.onRightClickDummySlot(object);
                            break block0;
                        }
                        case QUICK_MOVE: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 3, object));
                            this.onRightShiftDummySlot(object);
                            break block0;
                        }
                        case QUICK_CRAFT: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 6, object));
                            this.onLeftDragDummySlot(object);
                            break block0;
                        }
                        case THROW: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 5, object));
                            this.tryThrowStickFromDummySlot(object);
                        }
                    }
                    break;
                }
                case 4: {
                    if (pClickType != ClickType.CLONE) break;
                    if (object.equals("minecraft:air")) {
                        return;
                    }
                    NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 8, object));
                    this.onCloneFormDummySlot(object);
                    break;
                }
                case 5: {
                    if (pClickType != ClickType.QUICK_CRAFT) break;
                    NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 7, object));
                    this.onRightDragDummySlot(object);
                    break;
                }
                case 9: {
                    if (pClickType != ClickType.QUICK_CRAFT) break;
                    NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 9, object));
                    this.onDragCloneDummySlot(object);
                }
            }
        } else {
            super.clicked(pSlotId, pButton, pClickType, pPlayer);
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack quickMoveStack(Player player, int slotId) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotId);
        System.out.println(slotId);
        if (slot.hasItem()) {
            ItemStack movingStack = slot.getItem();
            itemStack = movingStack.copy();
            if (slotId >= 0 && slotId <= 35) {
                this.chest.addItem(movingStack);
                return ItemStack.EMPTY;
            }
            Const.LOGGER.warn("Ohh! Who trigger the quickMoveStack() when slotId >= 36 + CONTAINER_SLOT_SIZE in server side ?");
            if (movingStack.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (movingStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, movingStack);
        }
        return itemStack;
    }

    @ParametersAreNonnullByDefault
    public boolean canTakeItemForPickAll(ItemStack itemStack, Slot slot) {
        return slot.index <= 35;
    }

    @ParametersAreNonnullByDefault
    public boolean stillValid(Player player) {
        return !this.chestTile.isRemoved() && player.distanceToSqr((double)this.blockPos.getX() + 0.5, (double)this.blockPos.getY() + 0.5, (double)this.blockPos.getZ() + 0.5) <= 32.0;
    }

    @ParametersAreNonnullByDefault
    public void removed(Player player) {
        if (this.level.isClientSide) {
            return;
        }
        if (!this.chest.isRemoved()) {
            ((ServerChestHandler)this.chest).removeListener((ServerPlayer)player);
        }
        super.removed(player);
        if (!this.chestTile.isLocked()) {
            this.saveBlock();
        }
    }
}

