/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.menu;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.core.channel.ClientChannelManager;
import committee.nova.mods.avaritia.core.channel.IChannelTerminal;
import committee.nova.mods.avaritia.core.channel.ServerChannelManager;
import committee.nova.mods.avaritia.init.registry.ModMenus;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TesseractChannelMenu
extends AbstractContainerMenu {
    private final Player player;
    public final IChannelTerminal terminal;

    public TesseractChannelMenu(int containerId, Inventory playerInv, FriendlyByteBuf extraData) {
        super((MenuType)ModMenus.tesseract_channel.get(), containerId);
        this.player = playerInv.player;
        this.terminal = null;
    }

    public TesseractChannelMenu(int containerId, Player player, IChannelTerminal terminal) {
        super((MenuType)ModMenus.tesseract_channel.get(), containerId);
        this.player = player;
        this.terminal = terminal;
        ServerChannelManager.getInstance().addChannelSelector((ServerPlayer)player, terminal.getTerminalOwner());
        this.terminal.addChannelSelector((ServerPlayer)player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player pPlayer, int pIndex) {
        return ItemStack.EMPTY;
    }

    public boolean clickMenuButton(@NotNull Player pPlayer, int pId) {
        switch (pId) {
            case 0: {
                this.removeChannel();
                break;
            }
            case 1: {
                this.tryBack();
            }
        }
        return true;
    }

    public void setChannel(byte type, int id) {
        switch (type) {
            case 0: {
                this.terminal.setChannel(this.player.getUUID(), id);
                break;
            }
            case 1: {
                this.terminal.setChannel(this.terminal.getTerminalOwner(), id);
                break;
            }
            case 2: {
                this.terminal.setChannel(Const.AVARITIA_FAKE_PLAYER.getId(), id);
            }
        }
    }

    public void removeChannel() {
        this.terminal.removeChannel((ServerPlayer)this.player);
    }

    public void renameChannel(String name) {
        this.terminal.renameChannel((ServerPlayer)this.player, name);
    }

    private void tryBack() {
        this.terminal.removeChannelSelector((ServerPlayer)this.player);
        if (this.terminal.getChannelInfo() == null) {
            this.player.closeContainer();
        } else {
            this.terminal.tryReOpenMenu((ServerPlayer)this.player);
        }
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return this.terminal.stillValid();
    }

    public void removed(@NotNull Player pPlayer) {
        super.removed(pPlayer);
        if (pPlayer.isLocalPlayer()) {
            ClientChannelManager.getInstance().onScreenClose();
        } else {
            this.terminal.removeChannelSelector((ServerPlayer)pPlayer);
            ServerChannelManager.getInstance().removeChannelSelector((ServerPlayer)this.player);
        }
    }
}

