/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.net;

import committee.nova.mods.avaritia.api.iface.IFilterItem;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class C2SItemFilterPack {
    private final int action;
    private final ItemStack stack;

    public C2SItemFilterPack(FriendlyByteBuf buf) {
        this.action = buf.readInt();
        this.stack = buf.readItem();
    }

    public C2SItemFilterPack(int action, ItemStack stack) {
        this.action = action;
        this.stack = stack;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.action);
        buf.writeItem(this.stack);
    }

    public void run(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            if (player.getMainHandItem().getItem() instanceof IFilterItem) {
                CompoundTag tag = player.getMainHandItem().getOrCreateTag();
                switch (this.action) {
                    case 0: {
                        if (tag.contains("filters")) {
                            if (tag.getCompound("filters").contains(ForgeRegistries.ITEMS.getKey((Object)this.stack.getItem()).toString())) break;
                            tag.getCompound("filters").put(ForgeRegistries.ITEMS.getKey((Object)this.stack.getItem()).toString(), (Tag)this.stack.serializeNBT());
                            break;
                        }
                        CompoundTag filters = new CompoundTag();
                        filters.put(ForgeRegistries.ITEMS.getKey((Object)this.stack.getItem()).toString(), (Tag)this.stack.serializeNBT());
                        tag.put("filters", (Tag)filters);
                        break;
                    }
                    case 1: {
                        CompoundTag filters = tag.getCompound("filters");
                        if (!filters.contains(ForgeRegistries.ITEMS.getKey((Object)this.stack.getItem()).toString())) break;
                        filters.remove(ForgeRegistries.ITEMS.getKey((Object)this.stack.getItem()).toString());
                        break;
                    }
                    case 2: {
                        CompoundTag filters = tag.getCompound("filters");
                        filters.getAllKeys().forEach(arg_0 -> ((CompoundTag)filters).remove(arg_0));
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

