/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.net.channel;

import committee.nova.mods.avaritia.core.channel.ServerChannelManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class C2SAddChannelPack {
    private final String name;
    private final boolean pub;

    public C2SAddChannelPack(FriendlyByteBuf buf) {
        this.name = buf.readUtf(64);
        this.pub = buf.readBoolean();
    }

    public C2SAddChannelPack(String name, boolean pub) {
        this.name = name;
        this.pub = pub;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.name, 64);
        buf.writeBoolean(this.pub);
    }

    public void run(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (this.name.isEmpty()) {
                return;
            }
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            ServerChannelManager.getInstance().tryAddChannel(player, this.name, this.pub);
        });
        context.get().setPacketHandled(true);
    }
}

