/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.tile;

import committee.nova.mods.avaritia.api.common.tile.BaseInventoryTileEntity;
import committee.nova.mods.avaritia.api.common.wrapper.ItemStackWrapper;
import committee.nova.mods.avaritia.api.iface.ITileIO;
import committee.nova.mods.avaritia.api.util.ItemUtils;
import committee.nova.mods.avaritia.api.util.lang.Localizable;
import committee.nova.mods.avaritia.common.block.collector.NeutronCollectorBlock;
import committee.nova.mods.avaritia.common.menu.NeutronCollectorMenu;
import committee.nova.mods.avaritia.core.io.SideConfiguration;
import committee.nova.mods.avaritia.core.io.TileIOHandler;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import committee.nova.mods.avaritia.init.registry.enums.CollectorTier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeutronCollectorTile
extends BaseInventoryTileEntity
implements ITileIO {
    private SideConfiguration sideConfig = new SideConfiguration();
    private int activeOutputTick = 0;
    private static final int ACTIVE_OUTPUT_INTERVAL = 20;
    private final TileIOHandler ioHandler = new TileIOHandler(this, NeutronCollectorBlock.FACING);
    public final ItemStackWrapper inventory;
    public SimpleContainerData data = new SimpleContainerData(1);
    private int progress;
    private CollectorTier tier;

    public NeutronCollectorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.neutron_collector_tile.get(), pos, state);
        this.inventory = NeutronCollectorTile.createInventoryHandler();
        if (state.is((Block)ModBlocks.neutron_collector.get())) {
            this.tier = CollectorTier.DEFAULT;
        } else if (state.is((Block)ModBlocks.dense_neutron_collector.get())) {
            this.tier = CollectorTier.DENSE;
        } else if (state.is((Block)ModBlocks.denser_neutron_collector.get())) {
            this.tier = CollectorTier.DENSER;
        } else if (state.is((Block)ModBlocks.densest_neutron_collector.get())) {
            this.tier = CollectorTier.DENSEST;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, NeutronCollectorTile tile) {
        if (!level.isClientSide()) {
            ++tile.activeOutputTick;
            if (tile.activeOutputTick >= 20) {
                tile.activeOutputTick = 0;
                tile.handleActiveOutput();
            }
        }
        if (tile.canWork()) {
            ItemStack result = tile.inventory.getStackInSlot(0);
            ItemStack stack = tile.tier.production.getItems()[0];
            ++tile.progress;
            tile.data.set(0, tile.progress);
            if (tile.progress >= tile.tier.production_ticks) {
                if (result.isEmpty()) {
                    tile.inventory.setStackInSlot(0, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                } else if (result.is(stack.getItem()) && result.getCount() < 64) {
                    tile.inventory.setStackInSlot(0, ItemUtils.grow(result, 1));
                }
                tile.progress = 0;
                tile.setChangedAndDispatch();
            }
        }
    }

    public static ItemStackWrapper createInventoryHandler() {
        ItemStackWrapper inventory = new ItemStackWrapper(1, Integer.MAX_VALUE);
        inventory.setOutputSlots(0);
        return inventory;
    }

    @Override
    public void load(@NotNull CompoundTag tag) {
        super.load(tag);
        this.progress = tag.getInt("progress");
        if (tag.contains("SideConfig")) {
            this.sideConfig = SideConfiguration.fromNBT(tag.getCompound("SideConfig"));
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putInt("progress", this.progress);
        tag.put("SideConfig", (Tag)this.sideConfig.toNBT());
    }

    @Override
    @NotNull
    public ItemStackWrapper getInventory() {
        return this.inventory;
    }

    protected boolean canWork() {
        return this.inventory.getStackInSlot(0).isEmpty() || this.inventory.getStackInSlot(0).getCount() < 64;
    }

    @NotNull
    public Component getDisplayName() {
        return Localizable.of("block.avaritia." + this.tier.name).build();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory) {
        return new NeutronCollectorMenu(windowId, playerInventory, this.getBlockPos(), (ContainerData)this.data);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side != null && cap == ForgeCapabilities.ITEM_HANDLER && !this.ioHandler.shouldAllowPassiveIO(side)) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    public CollectorTier getTier() {
        return this.tier;
    }

    public void setTier(CollectorTier tier) {
        this.tier = tier;
    }

    public int getProductionTicks() {
        return this.tier.production_ticks;
    }

    public Item getProduction() {
        return this.tier.production.getItems()[0].getItem();
    }

    private void handleActiveOutput() {
        this.ioHandler.handleActiveIO();
    }

    @Override
    public SideConfiguration getSideConfiguration() {
        return this.sideConfig;
    }

    @Override
    public void setSideConfiguration(SideConfiguration config) {
        for (Direction direction : Direction.values()) {
            SideConfiguration.SideMode mode = config.getSideMode(direction);
            if (mode == SideConfiguration.SideMode.PASSIVE_OUTPUT || mode == SideConfiguration.SideMode.ACTIVE_OUTPUT) continue;
            config.setSideMode(direction, SideConfiguration.SideMode.OFF);
        }
        this.sideConfig = config;
        this.setChangedAndDispatch();
        if (!this.level.isClientSide()) {
            NetworkHandler.sendSideConfigSync(this.level, this.worldPosition, config);
        }
    }

    @Override
    public void setIOChange() {
        this.setChangedAndDispatch();
    }

    @Override
    public void cycleSideModeForNeutronCollector(Direction direction) {
        SideConfiguration.SideMode current = this.sideConfig.getSideMode(direction);
        SideConfiguration.SideMode nextMode = current == SideConfiguration.SideMode.OFF ? SideConfiguration.SideMode.PASSIVE_OUTPUT : (current == SideConfiguration.SideMode.PASSIVE_OUTPUT ? SideConfiguration.SideMode.ACTIVE_OUTPUT : SideConfiguration.SideMode.OFF);
        this.sideConfig.setSideMode(direction, nextMode);
        this.setChangedAndDispatch();
        if (!this.level.isClientSide()) {
            NetworkHandler.sendSideConfigSync(this.level, this.worldPosition, this.sideConfig);
        }
    }

    @Override
    public void extractFromHandler(IItemHandler externalHandler, Direction fromSide) {
    }

    @Override
    public void insertToHandler(IItemHandler externalHandler, Direction toSide) {
        ItemStack outputSlot = this.inventory.getStackInSlot(0);
        if (outputSlot.isEmpty()) {
            return;
        }
        ItemStack remaining = outputSlot.copy();
        for (int i = 0; i < externalHandler.getSlots() && !remaining.isEmpty(); ++i) {
            ItemStack insertResult = externalHandler.insertItem(i, remaining, false);
            int transferred = remaining.getCount() - insertResult.getCount();
            if (transferred <= 0) continue;
            outputSlot.shrink(transferred);
            remaining = insertResult;
        }
        if (!remaining.equals(outputSlot)) {
            this.setChanged();
        }
    }
}

