/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.tile;

import committee.nova.mods.avaritia.api.common.crafting.ICompressorRecipe;
import committee.nova.mods.avaritia.api.common.tile.BaseInventoryTileEntity;
import committee.nova.mods.avaritia.api.common.wrapper.ItemStackWrapper;
import committee.nova.mods.avaritia.api.iface.ITileIO;
import committee.nova.mods.avaritia.api.util.ItemUtils;
import committee.nova.mods.avaritia.api.util.lang.Localizable;
import committee.nova.mods.avaritia.common.block.compressor.NeutronCompressorBlock;
import committee.nova.mods.avaritia.common.menu.NeutronCompressorMenu;
import committee.nova.mods.avaritia.core.io.SideConfiguration;
import committee.nova.mods.avaritia.core.io.TileIOHandler;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import committee.nova.mods.avaritia.init.registry.enums.CompressorTier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeutronCompressorTile
extends BaseInventoryTileEntity
implements ITileIO {
    private SideConfiguration sideConfig = new SideConfiguration();
    private int activeIOtick = 0;
    private static final int ACTIVE_IO_INTERVAL = 20;
    private final TileIOHandler ioHandler = new TileIOHandler(this, NeutronCompressorBlock.FACING);
    private final ItemStackWrapper inventory;
    private final ItemStackWrapper recipeInventory;
    private final SimpleContainerData data = new SimpleContainerData(1);
    private ICompressorRecipe recipe;
    private ItemStack materialStack = ItemStack.EMPTY;
    private int materialCount;
    private int progress;
    private boolean recipeLocked = false;
    private ICompressorRecipe lockedRecipe = null;
    private CompressorTier tier;

    public NeutronCompressorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.neutron_compressor_tile.get(), pos, state);
        this.inventory = NeutronCompressorTile.createInventoryHandler();
        this.recipeInventory = new ItemStackWrapper(1);
        if (state.is((Block)ModBlocks.neutron_compressor.get())) {
            this.tier = CompressorTier.DEFAULT;
        } else if (state.is((Block)ModBlocks.dense_neutron_compressor.get())) {
            this.tier = CompressorTier.DENSE;
        } else if (state.is((Block)ModBlocks.denser_neutron_compressor.get())) {
            this.tier = CompressorTier.DENSER;
        } else if (state.is((Block)ModBlocks.densest_neutron_compressor.get())) {
            this.tier = CompressorTier.DENSEST;
        }
    }

    public static ItemStackWrapper createInventoryHandler() {
        ItemStackWrapper inventory = new ItemStackWrapper(2);
        inventory.setOutputSlots(0);
        return inventory;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, NeutronCompressorTile tile) {
        ItemStack output = tile.inventory.getStackInSlot(0);
        ItemStack input = tile.inventory.getStackInSlot(1);
        tile.recipeInventory.setStackInSlot(0, tile.materialStack);
        if (!level.isClientSide()) {
            ++tile.activeIOtick;
            if (tile.activeIOtick >= 20) {
                tile.activeIOtick = 0;
                tile.handleActiveIO();
            }
        }
        if (tile.recipeLocked && tile.lockedRecipe != null) {
            tile.recipe = tile.lockedRecipe.matches(tile.recipeInventory.toIInventory(), level) ? tile.lockedRecipe : null;
        } else if (tile.recipe == null || !tile.recipe.matches(tile.recipeInventory.toIInventory(), level)) {
            tile.recipe = level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.COMPRESSOR_RECIPE.get(), tile.recipeInventory.toIInventory(), level).orElse(null);
        }
        if (!level.isClientSide()) {
            if (!input.isEmpty()) {
                if (tile.materialStack.isEmpty() || tile.materialCount <= 0) {
                    tile.materialStack = input.copy();
                    tile.setChangedFast();
                }
                if (tile.recipe != null && (float)tile.materialCount < (float)tile.recipe.getInputCount() * tile.tier.inputAmplifier && ItemUtils.areStacksSameType(input, tile.materialStack)) {
                    int consumeAmount = input.getCount();
                    consumeAmount = Math.min(consumeAmount, Mth.ceil((float)((float)tile.recipe.getInputCount() * tile.tier.inputAmplifier)) - tile.materialCount);
                    input.shrink(consumeAmount);
                    tile.materialCount += consumeAmount;
                    tile.setChangedFast();
                }
            }
            if (tile.recipe != null && (float)tile.materialCount >= (float)tile.recipe.getInputCount() * tile.tier.inputAmplifier) {
                ItemStack result;
                tile.setProgress(tile.progress + 1);
                if ((float)tile.progress >= (float)tile.recipe.getTimeCost() * tile.tier.timeAmplifier && ItemUtils.canCombineStacks(result = tile.recipe.assemble(tile.inventory.toIInventory(), level.registryAccess()), output)) {
                    tile.updateResult(result, tile.tier.outputAmplifier);
                    tile.setProgress(0);
                    tile.materialCount -= Mth.ceil((float)((float)tile.recipe.getInputCount() * tile.tier.inputAmplifier));
                    if (tile.materialCount <= 0) {
                        tile.materialStack = ItemStack.EMPTY;
                    }
                    tile.setChangedFast();
                }
            }
        }
        tile.dispatchIfChanged();
    }

    @Override
    @NotNull
    public ItemStackWrapper getInventory() {
        return this.inventory;
    }

    @Override
    public void load(@NotNull CompoundTag tag) {
        super.load(tag);
        this.materialCount = tag.getInt("MaterialCount");
        this.materialStack = ItemStack.of((CompoundTag)tag.getCompound("MaterialStack"));
        this.setProgress(tag.getInt("Progress"));
        this.recipeLocked = tag.getBoolean("RecipeLocked");
        if (tag.contains("SideConfig")) {
            this.sideConfig = SideConfiguration.fromNBT(tag.getCompound("SideConfig"));
        }
        this.lockedRecipe = null;
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putInt("MaterialCount", this.materialCount);
        tag.put("MaterialStack", (Tag)this.materialStack.serializeNBT());
        tag.putInt("Progress", this.progress);
        tag.putBoolean("RecipeLocked", this.recipeLocked);
        tag.put("SideConfig", (Tag)this.sideConfig.toNBT());
    }

    @NotNull
    public Component getDisplayName() {
        return Localizable.of("block.avaritia." + this.tier.name).build();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory) {
        return new NeutronCompressorMenu(windowId, playerInventory, this.inventory, this.getBlockPos(), (ContainerData)this.data);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side != null && cap == ForgeCapabilities.ITEM_HANDLER && !this.ioHandler.shouldAllowPassiveIO(side)) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    public CompressorTier getTier() {
        return this.tier;
    }

    public void setTier(CompressorTier tier) {
        this.tier = tier;
    }

    public ItemStack getMaterialStack() {
        return this.materialStack;
    }

    public boolean hasMaterialStack() {
        return !this.materialStack.isEmpty();
    }

    public int getMaterialCount() {
        return this.materialCount;
    }

    public boolean hasRecipe() {
        return this.recipe != null;
    }

    public ICompressorRecipe getActiveRecipe() {
        return this.recipe;
    }

    public int getMaterialsRequired() {
        if (this.hasRecipe()) {
            return Mth.ceil((float)((float)this.recipe.getInputCount() * this.tier.inputAmplifier));
        }
        return 0;
    }

    public int getTimeRequired() {
        if (this.hasRecipe()) {
            return Mth.ceil((float)((float)this.recipe.getTimeCost() * this.tier.timeAmplifier));
        }
        return 0;
    }

    private void updateResult(ItemStack stack, int outputAmplifier) {
        ItemStack result = this.inventory.getStackInSlot(0);
        if (result.isEmpty()) {
            this.inventory.setStackInSlot(0, stack.copyWithCount(outputAmplifier));
        } else {
            this.inventory.setStackInSlot(0, ItemUtils.grow(result, stack.getCount() * outputAmplifier));
        }
    }

    public boolean isRecipeLocked() {
        return this.recipeLocked;
    }

    public void setRecipeLock(boolean locked, ICompressorRecipe recipe) {
        this.recipeLocked = locked;
        this.lockedRecipe = locked && recipe != null ? recipe : null;
        this.setChangedAndDispatch();
    }

    public ICompressorRecipe getLockedRecipe() {
        return this.lockedRecipe;
    }

    public void clearMaterials() {
        this.materialStack = ItemStack.EMPTY;
        this.materialCount = 0;
        this.setProgress(0);
        this.setChangedAndDispatch();
    }

    public boolean canEjectMaterials() {
        return this.materialCount > 0 && (this.recipe == null || (float)this.materialCount < (float)this.recipe.getInputCount() * this.tier.inputAmplifier);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot == 1 && this.recipeLocked && this.lockedRecipe != null) {
            NonNullList ingredients = this.lockedRecipe.getIngredients();
            if (!ingredients.isEmpty()) {
                Ingredient ingredient = (Ingredient)ingredients.get(0);
                ItemStack[] items = ingredient.getItems();
                return items.length > 0 && stack.is(items[0].getItem());
            }
            return false;
        }
        return true;
    }

    private void handleActiveIO() {
        this.ioHandler.handleActiveIO();
    }

    @Override
    public SideConfiguration getSideConfiguration() {
        return this.sideConfig;
    }

    @Override
    public void setSideConfiguration(SideConfiguration config) {
        this.sideConfig = config;
        this.setChangedAndDispatch();
        if (!this.level.isClientSide()) {
            NetworkHandler.sendSideConfigSync(this.level, this.worldPosition, config);
        }
    }

    @Override
    public void cycleSideModeForNeutronCollector(Direction direction) {
        SideConfiguration.SideMode current = this.sideConfig.getSideMode(direction);
        SideConfiguration.SideMode nextMode = current == SideConfiguration.SideMode.OFF ? SideConfiguration.SideMode.PASSIVE_MIXIN : (current == SideConfiguration.SideMode.PASSIVE_MIXIN ? SideConfiguration.SideMode.ACTIVE_INPUT : (current == SideConfiguration.SideMode.ACTIVE_INPUT ? SideConfiguration.SideMode.ACTIVE_OUTPUT : (current == SideConfiguration.SideMode.ACTIVE_OUTPUT ? SideConfiguration.SideMode.ACTIVE_MIXIN : SideConfiguration.SideMode.OFF)));
        this.sideConfig.setSideMode(direction, nextMode);
        this.setChangedAndDispatch();
        if (!this.level.isClientSide()) {
            NetworkHandler.sendSideConfigSync(this.level, this.worldPosition, this.sideConfig);
        }
    }

    @Override
    public void setIOChange() {
        this.setChangedAndDispatch();
    }

    @Override
    public void extractFromHandler(IItemHandler externalHandler, Direction fromSide) {
        ItemStack inputSlot = this.inventory.getStackInSlot(1);
        if (!inputSlot.isEmpty() && !ItemUtils.areStacksSameType(inputSlot, this.materialStack)) {
            return;
        }
        for (int i = 0; i < externalHandler.getSlots(); ++i) {
            int inputCount;
            ItemStack stack = externalHandler.getStackInSlot(i);
            if (stack.isEmpty() || !this.materialStack.isEmpty() && !ItemUtils.areStacksSameType(stack, this.materialStack)) continue;
            int maxTransfer = Math.min(stack.getCount(), 64);
            int spaceInInput = this.materialStack.isEmpty() ? 64 : (int)((float)this.recipe.getInputCount() * this.tier.inputAmplifier - (float)this.materialCount);
            int n = inputCount = inputSlot.isEmpty() ? 64 : inputSlot.getMaxStackSize() - inputSlot.getCount();
            if (spaceInInput + inputCount <= 0) break;
            int transferAmount = Math.min(maxTransfer, spaceInInput + inputCount);
            ItemStack extractedStack = externalHandler.extractItem(i, transferAmount, false);
            if (extractedStack.isEmpty()) continue;
            if (this.materialStack.isEmpty()) {
                this.materialStack = extractedStack.copy();
            }
            if (inputSlot.isEmpty()) {
                this.inventory.setStackInSlot(1, extractedStack.copy());
            } else {
                inputSlot.grow(extractedStack.getCount());
            }
            this.setChanged();
            break;
        }
    }

    @Override
    public void insertToHandler(IItemHandler externalHandler, Direction toSide) {
        ItemStack outputSlot = this.inventory.getStackInSlot(0);
        if (outputSlot.isEmpty()) {
            return;
        }
        ItemStack remaining = outputSlot.copy();
        for (int i = 0; i < externalHandler.getSlots() && !remaining.isEmpty(); ++i) {
            ItemStack insertResult = externalHandler.insertItem(i, remaining, false);
            int transferred = remaining.getCount() - insertResult.getCount();
            if (transferred <= 0) continue;
            outputSlot.shrink(transferred);
            remaining = insertResult;
        }
        if (!remaining.equals(outputSlot)) {
            this.setChanged();
        }
    }

    private void setProgress(int progress) {
        this.progress = progress;
        this.data.set(0, this.progress);
    }
}

