/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.channel;

import committee.nova.mods.avaritia.client.screen.TesseractChannelScreen;
import committee.nova.mods.avaritia.common.container.DummyChannelContainer;
import committee.nova.mods.avaritia.core.channel.ClientChannel;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="avaritia", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientChannelManager {
    private static volatile ClientChannelManager instance;
    private CompoundTag userCache;
    private final ClientChannel channel = new ClientChannel();
    public final HashMap<Integer, String> myChannels = new HashMap();
    public final HashMap<Integer, String> otherChannels = new HashMap();
    public final HashMap<Integer, String> publicChannels = new HashMap();
    public byte selectedChannelType = (byte)-1;
    public int selectedChannelID = -1;
    public String selectedChannelName = "";
    @Nullable
    private TesseractChannelScreen screen;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientChannelManager getInstance() {
        if (instance != null) return instance;
        Class<ClientChannelManager> clazz = ClientChannelManager.class;
        synchronized (ClientChannelManager.class) {
            if (instance != null) return instance;
            instance = new ClientChannelManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void newInstance() {
        if (instance != null) return;
        Class<ClientChannelManager> clazz = ClientChannelManager.class;
        synchronized (ClientChannelManager.class) {
            if (instance != null) return;
            instance = new ClientChannelManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @SubscribeEvent
    public static void onLoggingInServer(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientChannelManager.newInstance();
    }

    @SubscribeEvent
    public void onLoggingOutServer(ClientPlayerNetworkEvent.LoggingOut event) {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        instance = null;
    }

    public ClientChannelManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void setUserCache(CompoundTag userCache) {
        this.userCache = userCache;
    }

    public CompoundTag getUserCache() {
        return this.userCache;
    }

    public String getUserName(UUID uuid) {
        String userName = this.userCache.getCompound("nameCache").getString(uuid.toString());
        if (userName.equals("")) {
            return "unknownUser";
        }
        return userName;
    }

    public ClientChannel getChannel() {
        return this.channel;
    }

    public ClientChannel getChannel(DummyChannelContainer container) {
        this.channel.addListener(container);
        return this.channel;
    }

    public void updateChannel(CompoundTag data) {
        this.channel.update(data);
    }

    public void fullUpdateChannel(CompoundTag data) {
        this.channel.fullUpdate(data);
    }

    public void setChannelList(CompoundTag my, CompoundTag other, CompoundTag pub) {
        this.myChannels.clear();
        this.otherChannels.clear();
        this.publicChannels.clear();
        my.getAllKeys().forEach(s -> this.myChannels.put(Integer.parseInt(s), my.getString(s)));
        other.getAllKeys().forEach(s -> this.otherChannels.put(Integer.parseInt(s), other.getString(s)));
        pub.getAllKeys().forEach(s -> this.publicChannels.put(Integer.parseInt(s), pub.getString(s)));
    }

    public void addChannel(byte type, int id, String name) {
        switch (type) {
            case 0: {
                this.myChannels.put(id, name);
                break;
            }
            case 1: {
                this.otherChannels.put(id, name);
                break;
            }
            case 2: {
                this.publicChannels.put(id, name);
            }
        }
        if (this.screen != null) {
            this.screen.updateChannelList();
        }
    }

    public void removeChannel(byte type, int id, String name) {
        switch (type) {
            case 0: {
                this.myChannels.remove(id);
                break;
            }
            case 1: {
                this.otherChannels.remove(id);
                break;
            }
            case 2: {
                this.publicChannels.remove(id);
            }
        }
        if (this.screen != null) {
            this.screen.updateChannelList();
        }
    }

    public void setSelectedChannel(byte type, int ID, String name) {
        this.selectedChannelType = type;
        this.selectedChannelID = ID;
        this.selectedChannelName = name;
    }

    public void addScreen(TesseractChannelScreen screen) {
        this.screen = screen;
    }

    public void onScreenClose() {
        this.screen = null;
        this.otherChannels.clear();
        this.selectedChannelType = (byte)-1;
        this.selectedChannelID = -1;
        this.selectedChannelName = "";
    }
}

