/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.chest;

import committee.nova.mods.avaritia.core.chest.ClientChestHandler;
import committee.nova.mods.avaritia.core.chest.InfinityChestContainer;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="avaritia", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientChestManager {
    private static volatile ClientChestManager instance;
    private CompoundTag userCache;
    private final ClientChestHandler channel = new ClientChestHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientChestManager getInstance() {
        if (instance != null) return instance;
        Class<ClientChestManager> clazz = ClientChestManager.class;
        synchronized (ClientChestManager.class) {
            if (instance != null) return instance;
            instance = new ClientChestManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void newInstance() {
        if (instance != null) return;
        Class<ClientChestManager> clazz = ClientChestManager.class;
        synchronized (ClientChestManager.class) {
            if (instance != null) return;
            instance = new ClientChestManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @SubscribeEvent
    public static void onLoggingInServer(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientChestManager.newInstance();
    }

    @SubscribeEvent
    public void onLoggingOutServer(ClientPlayerNetworkEvent.LoggingOut event) {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        instance = null;
    }

    public ClientChestManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void setUserCache(CompoundTag userCache) {
        this.userCache = userCache;
    }

    public CompoundTag getUserCache() {
        return this.userCache;
    }

    public String getUserName(UUID uuid) {
        String userName = this.userCache.getCompound("nameCache").getString(uuid.toString());
        if (userName.isEmpty()) {
            return "unknownUser";
        }
        return userName;
    }

    public ClientChestHandler getChest() {
        return this.channel;
    }

    public ClientChestHandler getChest(InfinityChestContainer container) {
        this.channel.addListener(container);
        return this.channel;
    }

    public void updateChest(CompoundTag data) {
        this.channel.update(data);
    }

    public void fullUpdateChest(CompoundTag data) {
        this.channel.fullUpdate(data);
    }
}

