/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.chest;

import committee.nova.mods.avaritia.common.net.channel.ChannelState;
import committee.nova.mods.avaritia.common.net.chest.S2CInfinityChestStatePack;
import committee.nova.mods.avaritia.core.chest.ChestHandler;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.util.StorageUtils;
import java.util.HashSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ServerChestHandler
extends ChestHandler {
    private final HashSet<String> changedItems = new HashSet();
    private final HashSet<ServerPlayer> players = new HashSet();
    private boolean removed = false;

    public ServerChestHandler() {
    }

    public ServerChestHandler(CompoundTag dat) {
        this.initialize(dat);
    }

    @Override
    public void onItemChanged(String itemId, boolean listChanged) {
        super.onItemChanged(itemId, listChanged);
        this.changedItems.add(itemId);
    }

    public void initialize(CompoundTag dat) {
        this.storageItems.clear();
        this.nbtDataCache.clear();
        if (dat.contains("items")) {
            CompoundTag items = dat.getCompound("items");
            items.getAllKeys().forEach(itemId -> {
                if (items.getLong(itemId) > 0L && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(StorageUtils.getBaseItemId(itemId)))) {
                    this.storageItems.put(itemId, items.getLong(itemId));
                }
            });
        }
        if (dat.contains("nbtData")) {
            CompoundTag nbtData = dat.getCompound("nbtData");
            nbtData.getAllKeys().forEach(itemId -> {
                Tag nbtTag = nbtData.get(itemId);
                if (nbtTag instanceof CompoundTag) {
                    CompoundTag compoundTag = (CompoundTag)nbtTag;
                    this.nbtDataCache.put(itemId, compoundTag);
                }
            });
        }
        this.updateItemKeys();
    }

    public void addListener(ServerPlayer player) {
        this.players.add(player);
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CInfinityChestStatePack(ChannelState.FULL, this.buildData()));
    }

    public void removeListener(ServerPlayer player) {
        this.players.remove(player);
    }

    public void sendUpdate() {
        if (!this.hasChanged()) {
            return;
        }
        if (!this.players.isEmpty()) {
            CompoundTag tag = new CompoundTag();
            CompoundTag items = new CompoundTag();
            CompoundTag nbtData = new CompoundTag();
            this.changedItems.forEach(itemId -> {
                Tag nbtTag;
                items.putLong(itemId, this.storageItems.getOrDefault(itemId, 0L).longValue());
                if (itemId.contains("#") && this.nbtDataCache.containsKey(itemId) && (nbtTag = (Tag)this.nbtDataCache.get(itemId)) instanceof CompoundTag) {
                    CompoundTag compoundTag = (CompoundTag)nbtTag;
                    nbtData.put(itemId, (Tag)compoundTag);
                }
            });
            tag.put("items", (Tag)items);
            tag.put("nbtData", (Tag)nbtData);
            this.players.forEach(player -> NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CInfinityChestStatePack(ChannelState.COMMON, tag)));
        }
        this.resetChanged();
    }

    private boolean hasChanged() {
        return !this.changedItems.isEmpty();
    }

    private void resetChanged() {
        this.changedItems.clear();
    }

    public void sendFullUpdate() {
        if (!this.hasChanged()) {
            return;
        }
        if (!this.players.isEmpty()) {
            this.players.forEach(player -> NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CInfinityChestStatePack(ChannelState.FULL, this.buildData())));
        }
        this.changedItems.clear();
    }

    public CompoundTag buildData() {
        CompoundTag items = new CompoundTag();
        CompoundTag nbtData = new CompoundTag();
        this.storageItems.forEach((itemId, count) -> {
            Tag nbtTag;
            items.putLong(itemId, count.longValue());
            if (itemId.contains("#") && this.nbtDataCache.containsKey(itemId) && (nbtTag = (Tag)this.nbtDataCache.get(itemId)) instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)nbtTag;
                nbtData.put(itemId, (Tag)compoundTag);
            }
        });
        CompoundTag data = new CompoundTag();
        data.put("items", (Tag)items);
        data.put("nbtData", (Tag)nbtData);
        return data;
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved() {
        this.players.clear();
        this.removed = true;
    }
}

