/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.name;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.common.net.channel.ChannelState;
import committee.nova.mods.avaritia.common.net.channel.S2CChannelStatePack;
import committee.nova.mods.avaritia.common.net.chest.S2CInfinityChestStatePack;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import java.io.File;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="avaritia", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class NameCacheManager {
    private static volatile NameCacheManager instance;
    public CompoundTag userCache;
    private File saveDataPath;
    private boolean loadSuccess = true;
    private final MinecraftServer server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NameCacheManager getInstance() {
        if (instance != null) return instance;
        Class<NameCacheManager> clazz = NameCacheManager.class;
        synchronized (NameCacheManager.class) {
            if (instance != null) return instance;
            instance = new NameCacheManager(ServerLifecycleHooks.getCurrentServer());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void newInstance(MinecraftServer server) {
        if (instance != null) return;
        Class<NameCacheManager> clazz = NameCacheManager.class;
        synchronized (NameCacheManager.class) {
            if (instance != null) return;
            instance = new NameCacheManager(server);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onServerLoad(ServerAboutToStartEvent event) {
        NameCacheManager.newInstance(event.getServer());
    }

    private NameCacheManager(MinecraftServer server) {
        this.server = server;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.load();
    }

    @SubscribeEvent
    public void onLevelSave(LevelEvent.Save event) {
        if (!event.getLevel().isClientSide()) {
            this.save(event.getLevel().getServer());
        }
    }

    @SubscribeEvent
    public void onServerDown(ServerStoppingEvent event) {
        this.save(event.getServer());
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        instance = null;
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        this.userCache.getCompound("nameCache").putString(event.getEntity().getUUID().toString(), event.getEntity().getGameProfile().getName());
        NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new S2CChannelStatePack(ChannelState.NAME, this.userCache));
        NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new S2CInfinityChestStatePack(ChannelState.NAME, this.userCache));
        if (!this.loadSuccess) {
            event.getEntity().sendSystemMessage((Component)Component.translatable((String)"info.avaritia.channel.load_error"));
        }
    }

    private void load() {
        this.saveDataPath = new File(this.server.getWorldPath(LevelResource.ROOT).toFile(), "data/avaritia");
        try {
            File userCacheFile;
            if (!this.saveDataPath.exists()) {
                this.saveDataPath.mkdirs();
            }
            if ((userCacheFile = new File(this.saveDataPath, "UserCache.dat")).exists() && userCacheFile.isFile()) {
                this.userCache = NbtIo.readCompressed((File)userCacheFile);
                if (!this.userCache.contains("nameCache")) {
                    this.initializeNameCache();
                }
            } else {
                this.initializeNameCache();
            }
        }
        catch (Exception e) {
            this.loadSuccess = false;
            throw new RuntimeException("\u5728\u52a0\u8f7d\u6570\u636e\u7684\u65f6\u5019\u51fa\u9519\u4e86\uff01 \u672c\u6b21\u6e38\u620f\u5c06\u4e0d\u4f1a\u4fdd\u5b58\u6570\u636e\uff01", e);
        }
    }

    private void save(MinecraftServer server) {
        if (!this.loadSuccess) {
            return;
        }
        try {
            File userCache = new File(this.saveDataPath, "UserCache.dat");
            if (!userCache.exists()) {
                userCache.createNewFile();
            }
            NbtIo.writeCompressed((CompoundTag)this.userCache, (File)userCache);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5728\u4fdd\u5b58\u6570\u636e\u7684\u65f6\u5019\u51fa\u9519\u4e86\uff01 \u4ec0\u4e48\u60c5\u51b5\u5462\uff1f", e);
        }
    }

    private void initializeUserCache() {
        this.userCache = new CompoundTag();
        this.userCache.putInt("dataVersion", 1);
    }

    private void initializeNameCache() {
        CompoundTag nameCache = new CompoundTag();
        nameCache.putString(Const.AVARITIA_FAKE_PLAYER.getId().toString(), Const.AVARITIA_FAKE_PLAYER.getName());
        if (this.userCache == null) {
            this.initializeUserCache();
        }
        this.userCache.put("nameCache", (Tag)nameCache);
    }
}

