/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.singularity;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.core.singularity.SingularityDataManager;
import committee.nova.mods.avaritia.init.config.ModConfig;
import dev.latvian.mods.rhino.Context;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.fml.loading.FMLLoader;

public class Singularity {
    private final ResourceLocation registryName;
    private String displayName = "";
    private int[] colors = new int[]{3876692, 3876692};
    private String tag = null;
    private int count = Const.isLoad("projecte") ? 10000 : 1000;
    private int timeCost = FMLLoader.isProduction() ? (Integer)ModConfig.singularityTimeRequired.get() : 240;
    private Ingredient ingredient = Ingredient.EMPTY;
    private ICondition condition = null;
    private boolean enabled = true;
    private boolean recipeDisabled = false;

    public Singularity(ResourceLocation registryName) {
        this.registryName = registryName;
    }

    public Singularity setColors(int overlayColor, int underlayColor) {
        this.colors = new int[]{overlayColor, underlayColor};
        return this;
    }

    public Singularity setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Singularity setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public Singularity setCount(int count) {
        this.count = count;
        return this;
    }

    public Singularity setTimeCost(int timeCost) {
        this.timeCost = timeCost;
        return this;
    }

    public Singularity setIngredient(Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public Singularity setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Singularity setRecipeDisabled(boolean recipeDisabled) {
        this.recipeDisabled = recipeDisabled;
        return this;
    }

    public Singularity setCondition(ICondition condition) {
        this.condition = condition;
        return this;
    }

    public static Singularity create(ResourceLocation registryName, String displayName, int[] colors, Ingredient ingredient) {
        Singularity singularity = new Singularity(registryName);
        singularity.setDisplayName(displayName);
        singularity.setColors(colors[0], colors[1]);
        singularity.setIngredient(ingredient);
        return singularity;
    }

    public static Singularity create(ResourceLocation registryName, String displayName, int[] colors, String tag) {
        Singularity singularity = new Singularity(registryName);
        singularity.setDisplayName(displayName);
        singularity.setColors(colors[0], colors[1]);
        singularity.setTag(tag);
        return singularity;
    }

    public static Singularity read(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.readResourceLocation();
        String name = buffer.readUtf();
        int[] colors = buffer.readVarIntArray();
        boolean isTagIngredient = buffer.readBoolean();
        int timeRequired = buffer.readVarInt();
        String tag = null;
        Ingredient ingredient = Ingredient.EMPTY;
        if (isTagIngredient) {
            tag = buffer.readUtf();
        } else {
            ingredient = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        }
        int ingredientCount = buffer.readVarInt();
        boolean enabled = buffer.readBoolean();
        boolean recipeDisabled = buffer.readBoolean();
        return isTagIngredient ? new Singularity(id).setDisplayName(name).setColors(colors[0], colors[1]).setTag(tag).setCount(ingredientCount).setTimeCost(timeRequired).setEnabled(enabled).setRecipeDisabled(recipeDisabled) : new Singularity(id).setDisplayName(name).setColors(colors[0], colors[1]).setIngredient(ingredient).setCount(ingredientCount).setTimeCost(timeRequired).setEnabled(enabled).setRecipeDisabled(recipeDisabled);
    }

    public int getOverlayColor() {
        return this.colors[0];
    }

    public int getUnderlayColor() {
        return this.colors[1];
    }

    public Ingredient getIngredient() {
        if (this.tag != null && this.ingredient == Ingredient.EMPTY) {
            TagKey tag = ItemTags.create((ResourceLocation)new ResourceLocation(this.tag));
            this.ingredient = Ingredient.of((TagKey)tag);
        }
        return this.ingredient;
    }

    public int getCount() {
        if (this.count == -1) {
            return 1000;
        }
        return this.count;
    }

    public ICondition getCondition() {
        if (this.tag != null) {
            return new NotCondition((ICondition)new TagEmptyCondition(this.tag));
        }
        return null;
    }

    public static Singularity wrap(Context context, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Singularity) {
            return (Singularity)object;
        }
        if (object instanceof ResourceLocation) {
            return SingularityDataManager.getInstance().getSingularity((ResourceLocation)object);
        }
        if (object instanceof String) {
            return SingularityDataManager.getInstance().getSingularity(ResourceLocation.tryParse((String)((String)object)));
        }
        throw new IllegalArgumentException("Cannot convert object to Singularity: " + String.valueOf(object));
    }

    @Generated
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public int[] getColors() {
        return this.colors;
    }

    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public int getTimeCost() {
        return this.timeCost;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public boolean isRecipeDisabled() {
        return this.recipeDisabled;
    }
}

