/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat.jei;

import committee.nova.mods.avaritia.api.client.screen.BaseContainerScreen;
import committee.nova.mods.avaritia.client.screen.ExtremeAnvilScreen;
import committee.nova.mods.avaritia.client.screen.ExtremeSmithingScreen;
import committee.nova.mods.avaritia.client.screen.NeutronCompressorScreen;
import committee.nova.mods.avaritia.client.screen.craft.EndCraftScreen;
import committee.nova.mods.avaritia.client.screen.craft.ExtremeCraftScreen;
import committee.nova.mods.avaritia.client.screen.craft.NetherCraftScreen;
import committee.nova.mods.avaritia.client.screen.craft.SculkCraftScreen;
import committee.nova.mods.avaritia.common.menu.ExtremeAnvilMenu;
import committee.nova.mods.avaritia.common.menu.ExtremeSmithingMenu;
import committee.nova.mods.avaritia.common.menu.NeutronCompressorMenu;
import committee.nova.mods.avaritia.common.menu.TierCraftMenu;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.init.compat.jei.category.CompressorCategory;
import committee.nova.mods.avaritia.init.compat.jei.category.ExtremeSmithingRecipeCategory;
import committee.nova.mods.avaritia.init.compat.jei.category.tables.EndCraftingTableCategory;
import committee.nova.mods.avaritia.init.compat.jei.category.tables.ExtremeCraftingTableCategory;
import committee.nova.mods.avaritia.init.compat.jei.category.tables.NetherCraftingTableCategory;
import committee.nova.mods.avaritia.init.compat.jei.category.tables.SculkCraftingTableCategory;
import committee.nova.mods.avaritia.init.compat.jei.handler.JeiContainerHandler;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModMenus;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import committee.nova.mods.avaritia.util.SingularityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class AvaritiaJeiPlugin
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("avaritia", "jei_plugin");

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CompressorCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SculkCraftingTableCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new NetherCraftingTableCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new EndCraftingTableCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ExtremeCraftingTableCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ExtremeSmithingRecipeCategory(helper)});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null) {
            RecipeManager manager = world.getRecipeManager();
            registration.addRecipes(CompressorCategory.RECIPE_TYPE, manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.COMPRESSOR_RECIPE.get()));
            registration.addRecipes(ExtremeSmithingRecipeCategory.RECIPE_TYPE, manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.EXTREME_SMITHING_RECIPE.get()));
            Map<Integer, List> recipes = Stream.of(1, 2, 3, 4).collect(Collectors.toMap(tier -> tier, tier -> manager.byType((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.CRAFTING_TABLE_RECIPE.get()).values().stream().filter(recipe -> recipe.hasRequiredTier() ? tier.intValue() == recipe.getTier() : tier >= recipe.getTier()).toList()));
            registration.addRecipes(SculkCraftingTableCategory.RECIPE_TYPE, (List)recipes.getOrDefault(1, new ArrayList()));
            registration.addRecipes(NetherCraftingTableCategory.RECIPE_TYPE, (List)recipes.getOrDefault(2, new ArrayList()));
            registration.addRecipes(EndCraftingTableCategory.RECIPE_TYPE, (List)recipes.getOrDefault(3, new ArrayList()));
            registration.addRecipes(ExtremeCraftingTableCategory.RECIPE_TYPE, (List)recipes.getOrDefault(4, new ArrayList()));
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)((Block)ModBlocks.neutron_collector.get()).asItem()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.tooltip.avaritia.neutron_collector")});
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.neutron_pile.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.tooltip.avaritia.neutron_pile")});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.neutron_compressor.get()), new RecipeType[]{CompressorCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.sculk_crafting_table.get()), new RecipeType[]{SculkCraftingTableCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.nether_crafting_table.get()), new RecipeType[]{NetherCraftingTableCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.end_crafting_table.get()), new RecipeType[]{EndCraftingTableCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.extreme_crafting_table.get()), new RecipeType[]{ExtremeCraftingTableCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.extreme_smithing_table.get()), new RecipeType[]{ExtremeSmithingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.extreme_anvil.get()), new RecipeType[]{RecipeTypes.ANVIL});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(NeutronCompressorMenu.class, (MenuType)ModMenus.compressor.get(), CompressorCategory.RECIPE_TYPE, 1, 1, 2, 36);
        registration.addRecipeTransferHandler(TierCraftMenu.class, (MenuType)ModMenus.sculk_crafting_tile_table.get(), SculkCraftingTableCategory.RECIPE_TYPE, 1, 9, 10, 36);
        registration.addRecipeTransferHandler(TierCraftMenu.class, (MenuType)ModMenus.nether_crafting_tile_table.get(), NetherCraftingTableCategory.RECIPE_TYPE, 1, 25, 26, 36);
        registration.addRecipeTransferHandler(TierCraftMenu.class, (MenuType)ModMenus.end_crafting_tile_table.get(), EndCraftingTableCategory.RECIPE_TYPE, 1, 49, 50, 36);
        registration.addRecipeTransferHandler(TierCraftMenu.class, (MenuType)ModMenus.extreme_crafting_table.get(), ExtremeCraftingTableCategory.RECIPE_TYPE, 1, 81, 82, 36);
        registration.addRecipeTransferHandler(ExtremeSmithingMenu.class, (MenuType)ModMenus.extreme_smithing_table.get(), ExtremeSmithingRecipeCategory.RECIPE_TYPE, 1, 5, 6, 36);
        registration.addRecipeTransferHandler(ExtremeAnvilMenu.class, (MenuType)ModMenus.extreme_anvil.get(), RecipeTypes.ANVIL, 0, 2, 3, 36);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(NeutronCompressorScreen.class, 84, 35, 31, 12, new RecipeType[]{CompressorCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(SculkCraftScreen.class, 90, 40, 22, 12, new RecipeType[]{SculkCraftingTableCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(NetherCraftScreen.class, 105, 58, 22, 12, new RecipeType[]{NetherCraftingTableCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(EndCraftScreen.class, 135, 76, 22, 12, new RecipeType[]{EndCraftingTableCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(ExtremeCraftScreen.class, 174, 90, 22, 12, new RecipeType[]{ExtremeCraftingTableCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(ExtremeSmithingScreen.class, 86, 40, 22, 12, new RecipeType[]{ExtremeSmithingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(ExtremeAnvilScreen.class, 102, 48, 22, 15, new RecipeType[]{RecipeTypes.ANVIL});
        registration.addGenericGuiContainerHandler(BaseContainerScreen.class, (IGuiContainerHandler)new JeiContainerHandler());
    }

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registration) {
        ModItems.singularity.ifPresent(item -> registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, item, (stack, context) -> {
            Singularity singularity = SingularityUtils.getSingularity(stack);
            return singularity != null ? singularity.getRegistryName().toString() : "";
        }));
    }
}

