/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.handler;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.ModApi;
import committee.nova.mods.avaritia.api.util.recipe.RecipeUtils;
import committee.nova.mods.avaritia.common.crafting.recipe.CompressorRecipe;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.core.singularity.SingularityDataManager;
import committee.nova.mods.avaritia.core.singularity.SingularityReloadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SingularityHandler {
    @SubscribeEvent
    public static void onReloadSingularity(SingularityReloadEvent event) {
        try {
            SingularityDataManager.getInstance().setCachedSingularities(event.getSingularities());
            int generatedCount = 0;
            for (Singularity singularity : SingularityDataManager.getInstance().getSingularities()) {
                CompressorRecipe compressorRecipe;
                if (singularity.isRecipeDisabled() || (compressorRecipe = ModApi.addSingularityRecipe(singularity)) == null) continue;
                RecipeUtils.addRecipe(compressorRecipe);
                ++generatedCount;
            }
            Const.LOGGER.info("Singularity: Regenerated {} recipes", (Object)generatedCount);
        }
        catch (Exception e) {
            Const.LOGGER.error("Singularity: Failed to regenerate recipes", (Throwable)e);
        }
    }
}

