/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.mixins;

import committee.nova.mods.avaritia.init.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NetherWartBlock.class})
public abstract class NetherWartBlockMixin
extends BushBlock
implements BonemealableBlock {
    public NetherWartBlockMixin(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Inject(method={"mayPlaceOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void avaritia$mayPlaceOn(BlockState pState, BlockGetter pLevel, BlockPos pPos, CallbackInfoReturnable<Boolean> cir) {
        if (pState.is((Block)ModBlocks.soul_farmland.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, boolean pIsClient) {
        return !this.avaritia$isMaxAge(pState);
    }

    public boolean isBonemealSuccess(@NotNull Level pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        return true;
    }

    public void performBonemeal(@NotNull ServerLevel pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.avaritia$growCrops((Level)pLevel, pPos, pState);
    }

    @Unique
    public void avaritia$growCrops(Level level, BlockPos blockPos, BlockState blockState) {
        int j;
        int i = this.avaritia$getAge(blockState) + this.avaritia$getBonemealAgeIncrease(level);
        if (i > (j = this.avaritia$getMaxAge())) {
            i = j;
        }
        level.setBlock(blockPos, this.avaritia$getStateForAge(blockState, i), 2);
    }

    @Unique
    public BlockState avaritia$getStateForAge(BlockState blockState, int plantAge) {
        return (BlockState)blockState.getBlock().defaultBlockState().setValue((Property)this.avaritia$getAgeProperty(), (Comparable)Integer.valueOf(plantAge));
    }

    @Unique
    protected int avaritia$getBonemealAgeIncrease(Level level) {
        return Mth.nextInt((RandomSource)level.random, (int)2, (int)5) / 3;
    }

    @Unique
    protected int avaritia$getAge(BlockState blockState) {
        return (Integer)blockState.getValue((Property)this.avaritia$getAgeProperty());
    }

    @Unique
    public IntegerProperty avaritia$getAgeProperty() {
        return NetherWartBlock.AGE;
    }

    @Unique
    public int avaritia$getMaxAge() {
        return 3;
    }

    @Unique
    public boolean avaritia$isMaxAge(BlockState blockState) {
        return (Integer)blockState.getValue((Property)this.avaritia$getAgeProperty()) >= this.avaritia$getMaxAge();
    }
}

