/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;

public class StorageUtils {
    public static final String UUID_REGEX = "^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$";
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat(",###");
    private static final HashMap<Item, String> ITEM_ID_MAP = new HashMap();
    private static final HashMap<String, Item> ID_ITEM_MAP = new HashMap();
    private static final HashMap<Fluid, String> FLUID_ID_MAP = new HashMap();
    private static final HashMap<String, Fluid> ID_FLUID_MAP = new HashMap();

    public static String getItemId(ItemStack item) {
        return StorageUtils.getItemId(item.getItem());
    }

    public static String getItemId(Item item) {
        if (ITEM_ID_MAP.containsKey(item)) {
            return ITEM_ID_MAP.get(item);
        }
        String id = ForgeRegistries.ITEMS.getKey((Object)item).toString();
        ITEM_ID_MAP.put(item, id);
        ID_ITEM_MAP.put(id, item);
        return id;
    }

    public static Item getItem(String id) {
        if (ID_ITEM_MAP.containsKey(id)) {
            return ID_ITEM_MAP.get(id);
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(StorageUtils.getBaseItemId(id)));
        if (item == null || item.equals(Items.AIR)) {
            return Items.AIR;
        }
        ID_ITEM_MAP.put(id, item);
        ITEM_ID_MAP.put(item, id);
        return item;
    }

    public static String getFluidId(Fluid fluid) {
        if (FLUID_ID_MAP.containsKey(fluid)) {
            return FLUID_ID_MAP.get(fluid);
        }
        String id = ForgeRegistries.FLUIDS.getKey((Object)fluid).toString();
        FLUID_ID_MAP.put(fluid, id);
        ID_FLUID_MAP.put(id, fluid);
        return id;
    }

    public static Fluid getFluid(String id) {
        if (ID_FLUID_MAP.containsKey(id)) {
            return ID_FLUID_MAP.get(id);
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(id));
        if (fluid == null) {
            return Fluids.EMPTY;
        }
        ID_FLUID_MAP.put(id, fluid);
        FLUID_ID_MAP.put(fluid, id);
        return fluid;
    }

    public static String getNbtItemId(ItemStack item) {
        if (item.isEmpty()) {
            return "minecraft:air";
        }
        String itemId = StorageUtils.getItemId(item.getItem());
        if (!item.hasTag()) {
            return itemId;
        }
        String nbtHash = StorageUtils.hashNbt((Tag)item.getTag());
        return itemId + "#" + nbtHash;
    }

    public static String getBaseItemId(String nbtItemId) {
        int hashIndex = nbtItemId.indexOf(35);
        return hashIndex == -1 ? nbtItemId : nbtItemId.substring(0, hashIndex);
    }

    public static String hashNbt(Tag nbtTag) {
        if (nbtTag == null) {
            return "";
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (nbtTag instanceof CompoundTag) {
                NbtIo.writeCompressed((CompoundTag)((CompoundTag)nbtTag), (OutputStream)baos);
            } else {
                CompoundTag tempTag = new CompoundTag();
                tempTag.put("data", nbtTag);
                NbtIo.writeCompressed((CompoundTag)tempTag, (OutputStream)baos);
            }
            byte[] bytes = baos.toByteArray();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(bytes);
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString().substring(0, 16);
        }
        catch (Exception e) {
            return "error";
        }
    }

    public static class ViewType {
        public static final byte ALL = 0;
        public static final byte Items = 1;
        public static final byte Fluids = 2;
    }

    public static final class Action {
        public static final int LEFT_CLICK_DUMMY_SLOT = 0;
        public static final int Right_CLICK_DUMMY_SLOT = 1;
        public static final int LEFT_SHIFT_DUMMY_SLOT = 2;
        public static final int Right_SHIFT_DUMMY_SLOT = 3;
        public static final int THROW_ONE = 4;
        public static final int THROW_STICK = 5;
        public static final int LEFT_DRAG = 6;
        public static final int RIGHT_DRAG = 7;
        public static final int CLONE = 8;
        public static final int DRAG_CLONE = 9;
    }
}

