/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.render.pipeline.attribute;

import committee.nova.mods.avaritia.api.client.render.pipeline.IVertexOperation;
import committee.nova.mods.avaritia.api.util.SneakyUtils;
import committee.nova.mods.avaritia.api.util.java.ArrayUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;

public abstract class AttributeKey<T> {
    public final int attributeKeyIndex;
    public final int operationIndex;
    private final String name;

    public AttributeKey(String name) {
        this.name = name;
        this.attributeKeyIndex = AttributeKeyRegistry.registerAttributeKey(this);
        this.operationIndex = IVertexOperation.registerOperation();
    }

    public static <T> AttributeKey<T> create(String name, final IntFunction<T> factory) {
        return new AttributeKey<T>(name){

            @Override
            public T createDefault(int length) {
                return factory.apply(length);
            }

            @Override
            public T copy(T src, int length) {
                Object dst = this.createDefault(length);
                ArrayUtils.arrayCopy(src, 0, dst, 0, ((Object[])src).length);
                return dst;
            }

            @Override
            public T copyRange(T src, int srcpos, T dest, int destpos, int length) {
                ArrayUtils.arrayCopy(src, srcpos, dest, destpos, length);
                return dest;
            }
        };
    }

    public abstract T createDefault(int var1);

    public abstract T copy(T var1, int var2);

    public abstract T copyRange(T var1, int var2, T var3, int var4, int var5);

    public static class AttributeKeyRegistry {
        private static final Map<String, AttributeKey<?>> nameMap = new HashMap();
        private static final List<AttributeKey<?>> attributeKeys = new ArrayList();

        private static int registerAttributeKey(AttributeKey<?> attr) {
            if (nameMap.containsKey(attr.name)) {
                throw new IllegalArgumentException("Duplicate registration of attribute with name: " + attr.name);
            }
            nameMap.put(attr.name, attr);
            attributeKeys.add(attr);
            return attributeKeys.size() - 1;
        }

        public static <T> AttributeKey<T> getAttributeKey(int index) {
            return (AttributeKey)SneakyUtils.unsafeCast(attributeKeys.get(index));
        }

        public static int numAttributes() {
            return attributeKeys.size();
        }
    }
}

