/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.render.pipeline.attribute;

import committee.nova.mods.avaritia.api.client.render.CCRenderState;
import committee.nova.mods.avaritia.api.client.render.pipeline.VertexAttribute;
import committee.nova.mods.avaritia.api.client.render.pipeline.attribute.AttributeKey;
import committee.nova.mods.avaritia.api.client.render.pipeline.attribute.SideAttribute;
import committee.nova.mods.avaritia.api.util.vec.Rotation;
import committee.nova.mods.avaritia.api.util.vec.Vector3;

public class NormalAttribute
extends VertexAttribute<Vector3[]> {
    public static final AttributeKey<Vector3[]> attributeKey = AttributeKey.create("normal", Vector3[]::new);
    private Vector3[] normalRef;

    public NormalAttribute() {
        super(attributeKey);
    }

    @Override
    public boolean load(CCRenderState ccrs) {
        this.normalRef = ccrs.model.getAttribute(attributeKey);
        if (ccrs.model.hasAttribute(attributeKey)) {
            return this.normalRef != null;
        }
        if (ccrs.model.hasAttribute(SideAttribute.attributeKey)) {
            ccrs.pipeline.addDependency(ccrs.sideAttrib);
            return true;
        }
        throw new IllegalStateException("Normals requested but neither normal or side attrutes are provided by the model");
    }

    @Override
    public void operate(CCRenderState ccrs) {
        if (this.normalRef != null) {
            ccrs.normal.set(this.normalRef[ccrs.vertexIndex]);
        } else {
            ccrs.normal.set(Rotation.axes[ccrs.side]);
        }
    }
}

