/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import committee.nova.mods.avaritia.api.client.model.PerspectiveModelState;
import committee.nova.mods.avaritia.api.util.vec.Vector3;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class TransformUtils {
    public static final PerspectiveModelState IDENTITY = PerspectiveModelState.IDENTITY;
    public static final PerspectiveModelState DEFAULT_BLOCK;
    public static final PerspectiveModelState DEFAULT_ITEM;
    public static final PerspectiveModelState DEFAULT_TOOL;
    public static final PerspectiveModelState DEFAULT_BOW;
    public static final PerspectiveModelState DEFAULT_HANDHELD_ROD;
    public static final PerspectiveModelState DEFAULT_TRIDENT;
    private static final Transformation flipX;

    public static Transformation create(float tx, float ty, float tz, float rx, float ry, float rz, float s) {
        return TransformUtils.create(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), new Vector3f(rx, ry, rz), new Vector3f(s, s, s));
    }

    public static Transformation create(Vector3 transform, Vector3 rotation, Vector3 scale) {
        return TransformUtils.create(transform.vector3f(), rotation.vector3f(), scale.vector3f());
    }

    public static Transformation create(Vector3f transform, Vector3f rotation, Vector3f scale) {
        return new Transformation(transform, new Quaternionf().rotationXYZ((float)((double)rotation.x() * 0.017453292519943), (float)((double)rotation.y() * 0.017453292519943), (float)((double)rotation.z() * 0.017453292519943)), scale, null);
    }

    public static Transformation create(ItemTransform transform) {
        if (ItemTransform.NO_TRANSFORM.equals((Object)transform)) {
            return Transformation.identity();
        }
        return TransformUtils.create(transform.translation, transform.rotation, transform.scale);
    }

    public static Transformation flipLeft(Transformation transform) {
        return flipX.compose(transform).compose(flipX);
    }

    public static ModelState stateFromItemTransforms(ItemTransforms itemTransforms, Map<ItemDisplayContext, Transformation> additions) {
        if (itemTransforms == ItemTransforms.NO_TRANSFORMS) {
            return IDENTITY;
        }
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (ItemDisplayContext value : ItemDisplayContext.values()) {
            map.put((Object)value, (Object)TransformUtils.create(itemTransforms.getTransform(value)));
        }
        map.putAll(additions);
        return new PerspectiveModelState((Map<ItemDisplayContext, Transformation>)map.build());
    }

    public static PerspectiveModelState stateFromItemTransforms(ItemTransforms itemTransforms) {
        if (itemTransforms == ItemTransforms.NO_TRANSFORMS) {
            return IDENTITY;
        }
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (ItemDisplayContext value : ItemDisplayContext.values()) {
            map.put((Object)value, (Object)TransformUtils.create(itemTransforms.getTransform(value)));
        }
        return new PerspectiveModelState((Map<ItemDisplayContext, Transformation>)map.build());
    }

    public static void applyLeftyFlip(PoseStack pStack) {
        if (!pStack.clear()) {
            Matrix4f tMat = pStack.last().pose();
            Matrix3f nMat = pStack.last().normal();
            tMat.mulLocal((Matrix4fc)flipX.getMatrix());
            tMat.mul((Matrix4fc)flipX.getMatrix());
            nMat.mulLocal((Matrix3fc)flipX.getNormalMatrix());
            nMat.mul((Matrix3fc)flipX.getNormalMatrix());
            pStack.last().pose().mul((Matrix4fc)tMat);
            pStack.last().normal().mul((Matrix3fc)nMat);
        }
    }

    static {
        flipX = new Transformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
        HashMap<ItemDisplayContext, Transformation> map = new HashMap<ItemDisplayContext, Transformation>();
        Transformation thirdPerson = TransformUtils.create(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        map.put(ItemDisplayContext.GUI, TransformUtils.create(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
        map.put(ItemDisplayContext.GROUND, TransformUtils.create(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        map.put(ItemDisplayContext.FIXED, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, thirdPerson);
        map.put(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, TransformUtils.flipLeft(thirdPerson));
        map.put(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
        map.put(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f));
        DEFAULT_BLOCK = new PerspectiveModelState((Map<ItemDisplayContext, Transformation>)ImmutableMap.copyOf(map));
        map = new HashMap();
        thirdPerson = TransformUtils.create(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        Transformation firstPerson = TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
        map.put(ItemDisplayContext.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemDisplayContext.HEAD, TransformUtils.create(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        map.put(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, thirdPerson);
        map.put(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, TransformUtils.flipLeft(thirdPerson));
        map.put(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, firstPerson);
        map.put(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, TransformUtils.flipLeft(firstPerson));
        DEFAULT_ITEM = new PerspectiveModelState((Map<ItemDisplayContext, Transformation>)ImmutableMap.copyOf(map));
        map = new HashMap();
        map.put(ItemDisplayContext.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemDisplayContext.FIXED, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        map.put(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 4.0f, 0.5f, 0.0f, -90.0f, 55.0f, 0.85f));
        map.put(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f));
        map.put(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        map.put(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_TOOL = new PerspectiveModelState((Map<ItemDisplayContext, Transformation>)ImmutableMap.copyOf(map));
        map = new HashMap();
        map.put(ItemDisplayContext.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemDisplayContext.FIXED, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        map.put(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, TransformUtils.create(-1.0f, -2.0f, 2.5f, -80.0f, 260.0f, -40.0f, 0.9f));
        map.put(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, TransformUtils.create(-1.0f, -2.0f, 2.5f, -80.0f, -280.0f, 40.0f, 0.9f));
        map.put(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        map.put(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_BOW = new PerspectiveModelState((Map<ItemDisplayContext, Transformation>)ImmutableMap.copyOf(map));
        map = new HashMap();
        map.put(ItemDisplayContext.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 4.0f, 2.5f, 0.0f, 90.0f, 55.0f, 0.85f));
        map.put(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 4.0f, 2.5f, 0.0f, -90.0f, -55.0f, 0.85f));
        map.put(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 1.6f, 0.8f, 0.0f, 90.0f, 25.0f, 0.68f));
        map.put(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 1.6f, 0.8f, 0.0f, -90.0f, -25.0f, 0.68f));
        DEFAULT_HANDHELD_ROD = new PerspectiveModelState((Map<ItemDisplayContext, Transformation>)ImmutableMap.copyOf(map));
        map = new HashMap();
        map.put(ItemDisplayContext.GROUND, TransformUtils.create(4.0f, 4.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemDisplayContext.FIXED, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        map.put(ItemDisplayContext.GUI, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
        map.put(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, TransformUtils.create(11.0f, 17.0f, -2.0f, 0.0f, 60.0f, 0.0f, 1.0f));
        map.put(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, TransformUtils.create(-11.0f, 17.0f, 4.0f, 0.0f, 60.0f, 0.0f, 1.0f));
        map.put(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(-3.0f, 17.0f, 1.0f, 0.0f, -90.0f, 25.0f, 1.0f));
        map.put(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, TransformUtils.create(-15.0f, 17.0f, 1.0f, 0.0f, 90.0f, -25.0f, 1.0f));
        DEFAULT_TRIDENT = new PerspectiveModelState((Map<ItemDisplayContext, Transformation>)ImmutableMap.copyOf(map));
    }
}

