/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.util.key;

import committee.nova.mods.avaritia.api.client.util.key.GLFWKey;
import committee.nova.mods.avaritia.api.util.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GLFWKeyHelper {
    private static final Logger LOGGER;
    private static final Map<String, Integer> KEY_NAME_TO_CODE;
    private static final Map<Integer, String> KEY_CODE_TO_NAME;
    private static final Map<String, Integer> MOUSE_NAME_TO_CODE;
    private static final Map<Integer, String> MOUSE_CODE_TO_NAME;
    private static final Set<String> OPERATOR_KEYS;

    public static List<Integer> getKeyCodes(String ... keyNames) {
        ArrayList<Integer> codes = new ArrayList<Integer>();
        for (String name : keyNames) {
            Integer code = KEY_NAME_TO_CODE.get(name.toLowerCase());
            if (code == null) continue;
            codes.add(code);
        }
        Collections.sort(codes);
        return codes;
    }

    public static List<Integer> getMouseCodes(List<String> mouseNames) {
        ArrayList<Integer> codes = new ArrayList<Integer>();
        for (String name : mouseNames) {
            Integer code = MOUSE_NAME_TO_CODE.get(name.toLowerCase());
            if (code == null) continue;
            codes.add(code);
        }
        Collections.sort(codes);
        return codes;
    }

    public static List<String> getKeyDisplayNames(boolean sort, int ... codes) {
        ArrayList<String> operatorKeys = new ArrayList<String>();
        ArrayList<String> normalKeys = new ArrayList<String>();
        int[] nArray = codes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer code = nArray[i];
            String name = KEY_CODE_TO_NAME.get(code);
            if (StringUtils.isNullOrEmptyEx(name)) continue;
            if (sort && OPERATOR_KEYS.contains(name)) {
                operatorKeys.add(name);
                continue;
            }
            normalKeys.add(name);
        }
        if (sort) {
            operatorKeys.sort(Comparator.comparingInt(KEY_NAME_TO_CODE::get));
            normalKeys.sort(Comparator.comparingInt(KEY_NAME_TO_CODE::get));
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(operatorKeys);
        result.addAll(normalKeys);
        return result;
    }

    public static List<String> getMouseDisplayNames(boolean sort, int ... codes) {
        ArrayList<String> names = new ArrayList<String>();
        int[] nArray = codes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer code = nArray[i];
            String name = MOUSE_CODE_TO_NAME.get(code);
            if (StringUtils.isNullOrEmptyEx(name)) continue;
            names.add(name);
        }
        if (sort) {
            names.sort(Comparator.comparingInt(MOUSE_NAME_TO_CODE::get));
        }
        return names;
    }

    public static String getKeyDisplayString(int ... codes) {
        List<String> names = GLFWKeyHelper.getKeyDisplayNames(true, codes);
        return String.join((CharSequence)"+", names);
    }

    public static String getKeyDisplayStringInOrder(int ... codes) {
        List<String> names = GLFWKeyHelper.getKeyDisplayNames(false, codes);
        return String.join((CharSequence)"+", names);
    }

    public static String getMouseDisplayString(int ... codes) {
        List<String> names = GLFWKeyHelper.getMouseDisplayNames(true, codes);
        return String.join((CharSequence)"+", names);
    }

    public static String getMouseDisplayStringInOrder(int ... codes) {
        List<String> names = GLFWKeyHelper.getMouseDisplayNames(false, codes);
        return String.join((CharSequence)"+", names);
    }

    public static List<String> getKeyRecordKeys(int ... codes) {
        ArrayList<String> recordKeys = new ArrayList<String>();
        List<Integer> sortedCodes = Arrays.stream(codes).boxed().sorted().toList();
        for (Integer code : sortedCodes) {
            String name = KEY_CODE_TO_NAME.get(code);
            if (name == null) continue;
            recordKeys.add("key.keyboard." + GLFWKeyHelper.formatRecordName(name));
        }
        return recordKeys;
    }

    public static List<String> getMouseRecordKeys(int ... codes) {
        ArrayList<String> recordKeys = new ArrayList<String>();
        List<Integer> sortedCodes = Arrays.stream(codes).boxed().sorted().toList();
        for (Integer code : sortedCodes) {
            String name = MOUSE_CODE_TO_NAME.get(code);
            if (name == null) continue;
            recordKeys.add("key.mouse." + GLFWKeyHelper.formatRecordName(name));
        }
        return recordKeys;
    }

    public static boolean matchKey(String displayString, int ... codes) {
        List<String> generated = GLFWKeyHelper.getKeyDisplayNames(true, codes);
        List<String> inputKeys = GLFWKeyHelper.parseDisplayString(displayString);
        Comparator<String> comp = Comparator.comparing(String::toLowerCase);
        generated.sort(comp);
        inputKeys.sort(comp);
        return generated.equals(inputKeys);
    }

    public static boolean matchKeyInOrder(String displayString, int ... codes) {
        List<String> generated = GLFWKeyHelper.getKeyDisplayNames(false, codes);
        List<String> inputKeys = GLFWKeyHelper.parseDisplayString(displayString);
        return generated.equals(inputKeys);
    }

    public static boolean matchMouse(String displayString, int ... codes) {
        List<String> generated = GLFWKeyHelper.getMouseDisplayNames(true, codes);
        List<String> inputKeys = GLFWKeyHelper.parseDisplayString(displayString);
        Comparator<String> comp = Comparator.comparing(String::toLowerCase);
        generated.sort(comp);
        inputKeys.sort(comp);
        return generated.equals(inputKeys);
    }

    public static boolean matchMouseInOrder(String displayString, int ... codes) {
        List<String> generated = GLFWKeyHelper.getMouseDisplayNames(false, codes);
        List<String> inputKeys = GLFWKeyHelper.parseDisplayString(displayString);
        return generated.equals(inputKeys);
    }

    private static List<String> parseDisplayString(String displayString) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNullOrEmptyEx(displayString)) {
            return list;
        }
        for (String part : displayString.split("\\+")) {
            if (part.trim().isEmpty()) continue;
            list.add(part.trim());
        }
        return list;
    }

    private static String formatRecordName(String name) {
        String lower = name.toLowerCase();
        if (lower.startsWith("left")) {
            return "left" + (String)(lower.length() > 4 ? "." + lower.substring(4) : "");
        }
        if (lower.startsWith("right")) {
            return "right" + (String)(lower.length() > 5 ? "." + lower.substring(5) : "");
        }
        return lower;
    }

    static {
        Field[] fields;
        LOGGER = LogManager.getLogger();
        KEY_NAME_TO_CODE = new HashMap<String, Integer>();
        KEY_CODE_TO_NAME = new HashMap<Integer, String>();
        MOUSE_NAME_TO_CODE = new HashMap<String, Integer>();
        MOUSE_CODE_TO_NAME = new HashMap<Integer, String>();
        OPERATOR_KEYS = new HashSet<String>(Arrays.asList("Ctrl", "LeftCtrl", "RightCtrl", "LeftControl", "RightControl", "Shift", "LeftShift", "RightShift", "Alt", "LeftAlt", "RightAlt", "Super", "LeftSuper", "RightSuper", "Menu"));
        for (Field field : fields = GLFWKey.class.getDeclaredFields()) {
            String fieldName = field.getName();
            try {
                if (fieldName.startsWith("GLFW_KEY_")) {
                    int code = field.getInt(null);
                    String keyName = StringUtils.toPascalCase(fieldName.substring("GLFW_KEY_".length()));
                    KEY_NAME_TO_CODE.put(keyName, code);
                    KEY_CODE_TO_NAME.put(code, keyName);
                    continue;
                }
                if (!fieldName.startsWith("GLFW_MOUSE_BUTTON_")) continue;
                int code = field.getInt(null);
                String mouseName = StringUtils.toPascalCase("MOUSE_" + fieldName.substring("GLFW_MOUSE_BUTTON_".length()));
                MOUSE_NAME_TO_CODE.put(mouseName, code);
                MOUSE_CODE_TO_NAME.put(code, mouseName);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Failed to get key code from field: {}", (Object)fieldName, (Object)e);
            }
        }
    }
}

