/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.common.caps.item;

import committee.nova.mods.avaritia.api.common.caps.item.IItemCapabilitySerializable;
import committee.nova.mods.avaritia.api.common.caps.item.ItemCapability;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemCapabilitiesWrapper
implements ICapabilitySerializable<CompoundTag> {
    private final ItemCapability<?>[] capabilities;
    private final ItemStack itemStack;

    public ItemCapabilitiesWrapper(ItemStack stack, List<Supplier<ItemCapability<?>>> capabilities) {
        this.itemStack = stack;
        this.capabilities = new ItemCapability[capabilities.size()];
        for (int i = 0; i < capabilities.size(); ++i) {
            ItemCapability<?> cap = capabilities.get(i).get();
            this.capabilities[i] = cap;
            cap.setWrapper(this);
        }
    }

    public ItemCapabilitiesWrapper(ItemStack stack, ItemCapability<?> ... capabilities) {
        this.itemStack = stack;
        for (ItemCapability<?> cap : this.capabilities = capabilities) {
            cap.setWrapper(this);
        }
    }

    protected ItemStack getItemStack() {
        return this.itemStack;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        for (ItemCapability<?> cap : this.capabilities) {
            if (capability != cap.getCapability()) continue;
            return cap.getLazyCapability().cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag serializedNBT = new CompoundTag();
        for (ItemCapability<?> cap : this.capabilities) {
            if (!(cap instanceof IItemCapabilitySerializable)) continue;
            IItemCapabilitySerializable serializableCap = (IItemCapabilitySerializable)((Object)cap);
            serializedNBT.put(serializableCap.getStorageKey(), serializableCap.serializeNBT());
        }
        return serializedNBT;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (ItemCapability<?> cap : this.capabilities) {
            IItemCapabilitySerializable serializableCap;
            if (!(cap instanceof IItemCapabilitySerializable) || !nbt.contains((serializableCap = (IItemCapabilitySerializable)((Object)cap)).getStorageKey())) continue;
            serializableCap.deserializeNBT(nbt.get(serializableCap.getStorageKey()));
        }
    }
}

