/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.util.java;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class CollectionUtils {
    public static boolean isNullOrEmpty(Collection<?> list) {
        return list == null || list.isEmpty();
    }

    public static boolean isNotNullOrEmpty(Collection<?> list) {
        return !CollectionUtils.isNullOrEmpty(list);
    }

    public static boolean isNullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotNullOrEmpty(Object[] array) {
        return !CollectionUtils.isNullOrEmpty(array);
    }

    public static boolean isNullOrEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean equals(Object[] source, Object[] target) {
        if (!CollectionUtils.isNullOrEmpty(source) && !CollectionUtils.isNullOrEmpty(target)) {
            Object[] sourceEx = (Object[])source.clone();
            Object[] targetEx = (Object[])target.clone();
            Arrays.sort(sourceEx);
            Arrays.sort(targetEx);
            return Arrays.equals(sourceEx, targetEx);
        }
        return true;
    }

    public static boolean contains(String[] keys, String targetValue) {
        if (keys == null || keys.length == 0) {
            return false;
        }
        return Arrays.asList(keys).contains(targetValue);
    }

    public static boolean contains(String[] source, String[] target) {
        List<String> sourceList = Arrays.asList(source);
        List<String> targetList = Arrays.asList(target);
        return new HashSet<String>(sourceList).containsAll(targetList);
    }

    public static String[] setArrayPrefix(String[] array, String prefix) {
        String[] result = null;
        if (!CollectionUtils.isNullOrEmpty(array)) {
            result = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = prefix + array[i];
            }
        }
        return result;
    }

    public static String[] setArraySuffix(String[] array, String suffix) {
        String[] result = null;
        if (!CollectionUtils.isNullOrEmpty(array)) {
            result = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i] + suffix;
            }
        }
        return result;
    }

    public static String getMinLengthChar(String[] array) {
        String result = null;
        if (!CollectionUtils.isNullOrEmpty(array)) {
            result = Arrays.stream(array).min(Comparator.comparing(String::length)).orElse(null);
        }
        return result;
    }

    public static <T> T[] mergeArrays(T[] ... arrays) {
        if (arrays == null || arrays.length == 0) {
            throw new IllegalArgumentException("Input arrays must not be null or empty.");
        }
        int totalLength = 0;
        for (T[] array : arrays) {
            totalLength += array.length;
        }
        T[] mergedArray = Arrays.copyOf(arrays[0], totalLength);
        int destPos = arrays[0].length;
        for (int i = 1; i < arrays.length; ++i) {
            System.arraycopy(arrays[i], 0, mergedArray, destPos, arrays[i].length);
            destPos += arrays[i].length;
        }
        return mergedArray;
    }

    public static <T> T getRandomElement(T[] elements) {
        return CollectionUtils.getRandomElement(elements, (Random)ThreadLocalRandom.current());
    }

    public static <T> T getRandomElement(T[] elements, Random random) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        int index = random.nextInt(elements.length);
        return elements[index];
    }

    public static <T> T getRandomElement(Collection<T> elements) {
        return CollectionUtils.getRandomElement(elements, (Random)ThreadLocalRandom.current());
    }

    public static <T> T getRandomElement(Collection<T> elements, Random random) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        int index = random.nextInt(elements.size());
        return CollectionUtils.getNthElement(elements, index);
    }

    private static <T> T getNthElement(Collection<T> elements, int index) {
        int currentIndex = 0;
        for (T element : elements) {
            if (currentIndex == index) {
                return element;
            }
            ++currentIndex;
        }
        throw new IllegalStateException("Could not find element at the specified index.");
    }
}

