/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.util.math;

import java.util.HashMap;
import java.util.TreeSet;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InvItemCounter {
    private final HashMap<Item, Integer> invItemAmount = new HashMap();
    private final TreeSet<Integer> nbtItemIndex = new TreeSet();
    private final TreeSet<Integer> noNbtItemIndex = new TreeSet();
    private final NonNullList<ItemStack> itemList;
    private final Integer[] nbtItemIndexArray;
    private final Integer[] noNbtItemIndexArray;

    public InvItemCounter(Inventory inventory) {
        int i;
        this.itemList = inventory.items;
        for (i = 9; i < this.itemList.size(); ++i) {
            this.add(i);
        }
        for (i = 0; i < 9; ++i) {
            this.add(i);
        }
        this.nbtItemIndexArray = this.nbtItemIndex.toArray(new Integer[0]);
        this.noNbtItemIndexArray = this.noNbtItemIndex.toArray(new Integer[0]);
    }

    private void add(int i) {
        ItemStack invItem = (ItemStack)this.itemList.get(i);
        if (invItem.isEmpty()) {
            return;
        }
        if (invItem.hasTag()) {
            this.nbtItemIndex.add(i);
        } else {
            if (this.invItemAmount.containsKey(invItem.getItem())) {
                this.invItemAmount.replace(invItem.getItem(), this.invItemAmount.get(invItem.getItem()) + invItem.getCount());
            } else {
                this.invItemAmount.put(invItem.getItem(), invItem.getCount());
            }
            this.noNbtItemIndex.add(i);
        }
    }

    public int getCount(Item item) {
        return this.invItemAmount.getOrDefault(item, 0);
    }

    public int getCount(ItemStack itemStack) {
        int count = 0;
        if (itemStack.hasTag()) {
            for (Integer itemIndex : this.nbtItemIndex) {
                ItemStack itemStack1 = (ItemStack)this.itemList.get(itemIndex.intValue());
                if (!ItemStack.isSameItemSameTags((ItemStack)itemStack, (ItemStack)itemStack1)) continue;
                count += itemStack.getCount();
            }
            return count;
        }
        return this.getCount(itemStack.getItem());
    }

    public Integer[] getNbtItemIndex() {
        return this.nbtItemIndexArray;
    }

    public Integer[] getNoNbtItemIndex() {
        return this.noNbtItemIndexArray;
    }
}

