/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client;

import committee.nova.mods.avaritia.api.client.screen.ItemFilterScreen;
import committee.nova.mods.avaritia.api.iface.IFilterItem;
import committee.nova.mods.avaritia.client.screen.AvaritiaConfigScreen;
import committee.nova.mods.avaritia.common.entity.GapingVoidEntity;
import committee.nova.mods.avaritia.common.item.singularity.SingularityItem;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModItems;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;

@Mod.EventBusSubscriber(modid="avaritia", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AvaritiaForgeClient {
    private static final String CATEGORIES = "key.avaritia.categories";
    public static long lastTime = System.currentTimeMillis();
    public static int renderTime = 0;
    public static float renderFrame = 0.0f;
    public static boolean inventoryRender = false;
    private static float darknessIntensity = 0.0f;
    private static boolean keepFlying = false;
    public static final KeyMapping FILTER_KEY = new KeyMapping("key.avaritia.filter", 72, "key.avaritia.categories");
    public static final KeyMapping RING_KEY = new KeyMapping("key.avaritia.neutron_ring", 78, "key.avaritia.categories");
    public static final KeyMapping CONFIG_KEY = new KeyMapping("key.avaritia.config", 79, "key.avaritia.categories");
    private static Component[] tooltipExt = new Component[0];
    public static final IGuiOverlay DARKNESS_OVERLAY = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
        if (darknessIntensity > 0.01f) {
            AvaritiaForgeClient.renderDarknessOverlay(guiGraphics, screenWidth, screenHeight, darknessIntensity);
        }
    };

    @SubscribeEvent
    public static void onClientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        ClientLevel level = mc.level;
        if (player == null || level == null) {
            return;
        }
        while (CONFIG_KEY.consumeClick()) {
            mc.setScreen((Screen)new AvaritiaConfigScreen(mc.screen));
        }
        while (FILTER_KEY.consumeClick()) {
            if (player.getMainHandItem().isEmpty() || !(player.getMainHandItem().getItem() instanceof IFilterItem)) continue;
            Minecraft.getInstance().setScreen((Screen)new ItemFilterScreen());
        }
        if (!Minecraft.getInstance().isPaused()) {
            ++renderTime;
        }
        AvaritiaForgeClient.handleInfinityElytraFallFlying(mc, (Player)player);
        AvaritiaForgeClient.calculateDarknessIntensity((Player)player, (Level)level);
        AvaritiaForgeClient.singularityIconTimer();
    }

    public static void handleInfinityElytraFallFlying(Minecraft mc, Player player) {
        if (player.getItemBySlot(EquipmentSlot.CHEST).getItem() != ModItems.infinity_elytra.get()) {
            keepFlying = false;
            return;
        }
        boolean isFlying = player.isFallFlying();
        if (mc.options.keyJump.isDown()) {
            keepFlying = false;
            return;
        }
        if (isFlying && !keepFlying) {
            keepFlying = true;
        }
        if (keepFlying && player.onGround()) {
            keepFlying = false;
            double radius = 2.5;
            List nearby = player.level().getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(radius), e -> e != player);
            for (LivingEntity target : nearby) {
                target.hurt(player.damageSources().fellOutOfWorld(), 6.0f);
            }
            return;
        }
        if (keepFlying) {
            if (!player.isFallFlying()) {
                player.startFallFlying();
            }
            Vec3 look = player.getLookAngle().normalize();
            double FLY_SPEED = (Double)ModConfig.infinityElytraFlyingSpeed.get();
            player.setDeltaMovement(look.x * FLY_SPEED, look.y * FLY_SPEED, look.z * FLY_SPEED);
        }
    }

    public static void setTooltip(Component ... string) {
        tooltipExt = string;
    }

    @SubscribeEvent
    public static void getTooltip(ItemTooltipEvent evt) {
        Collections.addAll(evt.getToolTip(), tooltipExt);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemTooltip(ItemTooltipEvent e) {
        if (!FMLLoader.isProduction() || ((Boolean)ModConfig.useAdvanceTooltips.get()).booleanValue()) {
            CompoundTag tag;
            ItemStack stack = e.getItemStack();
            List tooltips = e.getToolTip();
            if (Screen.hasAltDown() && (tag = stack.getTag()) != null) {
                AvaritiaForgeClient.addTagCompound("  ", tooltips, tag);
            }
        }
    }

    private static void addTagCompound(String prefix, List<Component> list, CompoundTag tag) {
        TreeSet sortedKeys = new TreeSet(tag.getAllKeys());
        for (String key : sortedKeys) {
            AvaritiaForgeClient.addTag(prefix, key, list, tag.get(key));
        }
    }

    private static void addTag(String prefix, String key, List<Component> list, Tag tag) {
        switch (tag.getId()) {
            case 2: {
                list.add((Component)Component.literal((String)(prefix + key + ": \u00a72" + ((NumericTag)tag).getAsShort())));
                break;
            }
            case 3: {
                list.add((Component)Component.literal((String)(prefix + key + ": \u00a73" + ((NumericTag)tag).getAsInt())));
                break;
            }
            case 6: {
                list.add((Component)Component.literal((String)(prefix + key + ": \u00a76" + ((NumericTag)tag).getAsDouble())));
                break;
            }
            case 1: {
                list.add((Component)Component.literal((String)(prefix + key + ": \u00a79" + ((NumericTag)tag).getAsByte())));
                break;
            }
            case 8: {
                list.add((Component)Component.literal((String)(prefix + key + ": \u00a78" + tag.getAsString())));
                break;
            }
            case 9: {
                list.add((Component)Component.literal((String)(prefix + key + ": \u00a79List, " + ((ListTag)tag).size() + " items")));
                if (!Screen.hasShiftDown()) break;
                for (Tag key1 : (ListTag)tag) {
                    AvaritiaForgeClient.addTag(prefix, "    ", list, key1);
                }
                break;
            }
            case 10: {
                list.add((Component)Component.literal((String)(prefix + key + ": \u00a7aCompound")));
                if (!Screen.hasShiftDown()) break;
                AvaritiaForgeClient.addTagCompound(prefix + "    ", list, (CompoundTag)tag);
                break;
            }
            default: {
                list.add((Component)Component.literal((String)(prefix + key + ": Type " + String.valueOf(tag.getType()))));
            }
        }
    }

    private static void renderDarknessOverlay(GuiGraphics guiGraphics, int width, int height, float intensity) {
        int alpha = (int)(intensity * 255.0f);
        if (alpha > 255) {
            alpha = 255;
        }
        guiGraphics.fill(0, 0, width, height, alpha << 24 | 0);
    }

    private static void calculateDarknessIntensity(Player player, Level level) {
        Vec3 playerPos = player.position();
        double maxDistance = 10.0;
        float maxIntensity = 0.0f;
        for (GapingVoidEntity pearl : level.getEntitiesOfClass(GapingVoidEntity.class, player.getBoundingBox().inflate(maxDistance), Entity::isAlive)) {
            float intensity;
            double distance = playerPos.distanceTo(pearl.position());
            if (!(distance < maxDistance) || !((intensity = (float)Math.max(0.0, 1.0 - Math.max(0.0, (distance - 4.0) / 6.0))) > maxIntensity)) continue;
            maxIntensity = intensity;
        }
        if (maxIntensity > darknessIntensity) {
            darknessIntensity = Math.min(maxIntensity, darknessIntensity + 0.05f);
        } else if (maxIntensity < darknessIntensity) {
            darknessIntensity = Math.max(maxIntensity, darknessIntensity - 0.05f);
        }
    }

    private static void singularityIconTimer() {
        if (renderTime % 20 != 0) {
            return;
        }
        if (SingularityItem.enabledSingularities != null && !SingularityItem.enabledSingularities.isEmpty()) {
            SingularityItem.currentSingularityIndex.set((SingularityItem.currentSingularityIndex.get() + 1) % SingularityItem.enabledSingularities.size());
        }
    }

    @SubscribeEvent
    public static void onRenderTickStart(TickEvent.RenderTickEvent event) {
        if (!Minecraft.getInstance().isPaused() && event.phase == TickEvent.Phase.START) {
            renderFrame = event.renderTickTime;
        }
    }

    @SubscribeEvent
    public static void drawScreenPre(ScreenEvent.Render.Pre e) {
        inventoryRender = true;
    }

    @SubscribeEvent
    public static void drawScreenPost(ScreenEvent.Render.Post e) {
        inventoryRender = false;
    }
}

