/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.client.AvaritiaForgeClient;
import committee.nova.mods.avaritia.client.shader.AvaritiaRenderTypes;
import committee.nova.mods.avaritia.client.shader.AvaritiaShaders;
import committee.nova.mods.avaritia.init.registry.ModItems;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class InfinityArmorModel
extends HumanoidModel<LivingEntity> {
    public final ModelPart root = InfinityArmorModel.createLayer().bakeRoot();
    public final ModelPart bodyRoot = InfinityArmorModel.createBodyLayer(new CubeDeformation(1.0f)).bakeRoot();
    private boolean isSilm;

    public InfinityArmorModel(ModelPart root, boolean isSilm) {
        super(root);
        this.isSilm = isSilm;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        CubeDeformation cubeDeformation = new CubeDeformation(0.0f);
        partDefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -11.6f, 0.0f, 0.0f, 32.0f, 32.0f, cubeDeformation), PartPose.offsetAndRotation((float)-1.5f, (float)0.0f, (float)2.0f, (float)0.0f, (float)1.2566371f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, -11.6f, 0.0f, 0.0f, 32.0f, 32.0f, cubeDeformation), PartPose.offsetAndRotation((float)1.5f, (float)0.0f, (float)2.0f, (float)0.0f, (float)-1.2566371f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubDeformation) {
        MeshDefinition meshDefinition = HumanoidModel.createMesh((CubeDeformation)cubDeformation, (float)0.0f);
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubDeformation.extend(-0.1f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 48).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubDeformation.extend(-0.6f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubDeformation.extend(-0.6f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_boot", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubDeformation.extend(-0.1f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_boot", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubDeformation.extend(-0.1f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg);
    }

    public void setScale(ModelPart modelPart, float scale) {
        modelPart.xScale = scale;
        modelPart.yScale = scale;
        modelPart.zScale = scale;
    }

    public void setupAnim(@NotNull LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ModelPart leftWing = this.root.getChild("left_wing");
        leftWing.xRot = this.body.xRot;
        leftWing.yRot = this.body.yRot + 1.2566371f;
        leftWing.zRot = this.body.zRot;
        ModelPart rightWing = this.root.getChild("right_wing");
        rightWing.xRot = this.body.xRot;
        rightWing.yRot = this.body.yRot + -1.2566371f;
        rightWing.zRot = this.body.zRot;
        if (livingEntity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)livingEntity;
            this.head.y = 1.0f;
            this.head.xRot = (float)Math.PI / 180 * armorStand.getHeadPose().getX();
            this.head.yRot = (float)Math.PI / 180 * armorStand.getHeadPose().getY();
            this.head.zRot = (float)Math.PI / 180 * armorStand.getHeadPose().getZ();
            this.leftArm.xRot = (float)Math.PI / 180 * armorStand.getLeftArmPose().getX();
            this.leftArm.yRot = (float)Math.PI / 180 * armorStand.getLeftArmPose().getY();
            this.leftArm.zRot = (float)Math.PI / 180 * armorStand.getLeftArmPose().getZ();
            this.rightArm.xRot = (float)Math.PI / 180 * armorStand.getRightArmPose().getX();
            this.rightArm.yRot = (float)Math.PI / 180 * armorStand.getRightArmPose().getY();
            this.rightArm.zRot = (float)Math.PI / 180 * armorStand.getRightArmPose().getZ();
            this.leftLeg.xRot = (float)Math.PI / 180 * armorStand.getLeftLegPose().getX();
            this.leftLeg.yRot = (float)Math.PI / 180 * armorStand.getLeftLegPose().getY();
            this.leftLeg.zRot = (float)Math.PI / 180 * armorStand.getLeftLegPose().getZ();
            this.rightLeg.xRot = (float)Math.PI / 180 * armorStand.getRightLegPose().getX();
            this.rightLeg.yRot = (float)Math.PI / 180 * armorStand.getRightLegPose().getY();
            this.rightLeg.zRot = (float)Math.PI / 180 * armorStand.getRightLegPose().getZ();
            this.hat.copyFrom(this.head);
        }
        ModelPart head = this.bodyRoot.getChild("head");
        head.copyFrom(this.head);
        ModelPart hat = this.bodyRoot.getChild("hat");
        hat.copyFrom(this.hat);
        ModelPart body = this.bodyRoot.getChild("body");
        body.copyFrom(this.body);
        if (livingEntity instanceof Zombie) {
            Zombie zombie = (Zombie)livingEntity;
            AnimationUtils.animateZombieArms((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)zombie.isAggressive(), (float)this.attackTime, (float)ageInTicks);
        }
        ModelPart leftArm = this.bodyRoot.getChild("left_arm");
        leftArm.copyFrom(this.leftArm);
        if (!this.isSilm) {
            this.setScale(this.leftArm, 1.01f);
        } else {
            this.leftArm.x -= 0.3f;
            this.leftArm.xScale = 0.8f;
            this.leftArm.yScale = 1.01f;
        }
        this.setScale(leftArm, 1.0f);
        ModelPart rightArm = this.bodyRoot.getChild("right_arm");
        rightArm.copyFrom(this.rightArm);
        if (!this.isSilm) {
            this.setScale(this.rightArm, 1.01f);
        } else {
            this.rightArm.x += 0.3f;
            this.rightArm.xScale = 0.8f;
            this.rightArm.yScale = 1.01f;
        }
        this.setScale(rightArm, 1.0f);
        ModelPart leftLeg = this.bodyRoot.getChild("left_leg");
        leftLeg.copyFrom(this.leftLeg);
        ModelPart rightLeg = this.bodyRoot.getChild("right_leg");
        rightLeg.copyFrom(this.rightLeg);
        ModelPart leftBoot = this.bodyRoot.getChild("left_boot");
        leftBoot.copyFrom(this.leftLeg);
        ModelPart rightBoot = this.bodyRoot.getChild("right_boot");
        rightBoot.copyFrom(this.rightLeg);
    }

    public void render(LivingEntity livingEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        RenderType COSMIC_ARMOR_RENDER_TYPE = AvaritiaRenderTypes.COSMIC_ARMOR;
        Minecraft mc = Minecraft.getInstance();
        Item headItem = livingEntity.getItemBySlot(EquipmentSlot.HEAD).getItem();
        Item chestItem = livingEntity.getItemBySlot(EquipmentSlot.CHEST).getItem();
        Item legsItem = livingEntity.getItemBySlot(EquipmentSlot.LEGS).getItem();
        Item feetItem = livingEntity.getItemBySlot(EquipmentSlot.FEET).getItem();
        long time = 0L;
        if (mc.level != null) {
            time = mc.level.getGameTime();
        }
        double pulse = Math.sin((double)time / 10.0) * 0.5 + 0.5;
        double pulse_mag_sqr = pulse * pulse * pulse * pulse * pulse * pulse;
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 1.0f;
        if (AvaritiaForgeClient.inventoryRender) {
            scale = 100.0f;
        } else {
            yaw = (float)((double)(livingEntity.getYRot() * 2.0f) * Math.PI / 360.0);
            pitch = -((float)((double)(livingEntity.getXRot() * 2.0f) * Math.PI / 360.0));
        }
        AvaritiaShaders.cosmicArmorTime.set((float)(time % Integer.MAX_VALUE));
        AvaritiaShaders.cosmicArmorYaw.set(yaw);
        AvaritiaShaders.cosmicArmorPitch.set(pitch);
        AvaritiaShaders.cosmicArmorExternalScale.set(scale);
        AvaritiaShaders.cosmicArmorOpacity.set(1.25f);
        AvaritiaShaders.cosmicArmorUVs.set(AvaritiaShaders.COSMIC_UVS);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (chestItem == ModItems.infinity_chestplate.get() && player.getAbilities().flying) {
                poseStack.pushPose();
                ModelPart leftWing = this.root.getChild("left_wing");
                ModelPart rightWing = this.root.getChild("right_wing");
                leftWing.render(poseStack, vertexConsumer, packedLight, packedOverlay);
                rightWing.render(poseStack, vertexConsumer, packedLight, packedOverlay);
                leftWing.render(poseStack, Res.ARMOR_WING_MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
                rightWing.render(poseStack, Res.ARMOR_WING_MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
                leftWing.render(poseStack, multiBufferSource.getBuffer(AvaritiaRenderTypes.WingGlow(Res.WING_GLOW_TEX)), packedLight, packedOverlay, 0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5));
                rightWing.render(poseStack, multiBufferSource.getBuffer(AvaritiaRenderTypes.WingGlow(Res.WING_GLOW_TEX)), packedLight, packedOverlay, 0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5));
                poseStack.popPose();
            }
        }
        if (headItem == ModItems.infinity_helmet.get()) {
            poseStack.pushPose();
            ModelPart head = this.bodyRoot.getChild("head");
            head.render(poseStack, Res.ARMOR_MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            ModelPart hat = this.bodyRoot.getChild("hat");
            hat.render(poseStack, Res.ARMOR_MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.popPose();
        }
        if (chestItem == ModItems.infinity_chestplate.get()) {
            poseStack.pushPose();
            ModelPart body = this.bodyRoot.getChild("body");
            body.render(poseStack, Res.ARMOR_MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            body.render(poseStack, multiBufferSource.getBuffer(AvaritiaRenderTypes.WingGlow(Res.EYE_TEX)), packedLight, packedOverlay, 0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5));
            ModelPart leftArm = this.bodyRoot.getChild("left_arm");
            leftArm.render(poseStack, Res.ARMOR_MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            leftArm.render(poseStack, multiBufferSource.getBuffer(AvaritiaRenderTypes.WingGlow(Res.EYE_TEX)), packedLight, packedOverlay, 0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5));
            ModelPart rightArm = this.bodyRoot.getChild("right_arm");
            rightArm.render(poseStack, Res.ARMOR_MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            rightArm.render(poseStack, multiBufferSource.getBuffer(AvaritiaRenderTypes.WingGlow(Res.EYE_TEX)), packedLight, packedOverlay, 0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5));
            poseStack.popPose();
        }
        if (legsItem == ModItems.infinity_pants.get()) {
            poseStack.pushPose();
            ModelPart leftLeg = this.bodyRoot.getChild("left_leg");
            leftLeg.render(poseStack, Res.ARMOR_MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            leftLeg.render(poseStack, multiBufferSource.getBuffer(AvaritiaRenderTypes.WingGlow(Res.EYE_TEX)), packedLight, packedOverlay, 0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5));
            ModelPart rightLeg = this.bodyRoot.getChild("right_leg");
            rightLeg.render(poseStack, Res.ARMOR_MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            rightLeg.render(poseStack, multiBufferSource.getBuffer(AvaritiaRenderTypes.WingGlow(Res.EYE_TEX)), packedLight, packedOverlay, 0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5));
            poseStack.popPose();
        }
        if (feetItem == ModItems.infinity_boots.get()) {
            poseStack.pushPose();
            ModelPart leftBoot = this.bodyRoot.getChild("left_boot");
            leftBoot.render(poseStack, Res.ARMOR_MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            ModelPart rightBoot = this.bodyRoot.getChild("right_boot");
            rightBoot.render(poseStack, Res.ARMOR_MASK.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.popPose();
        }
        if (headItem == ModItems.infinity_helmet.get() && chestItem == ModItems.infinity_chestplate.get() && legsItem == ModItems.infinity_pants.get() && feetItem == ModItems.infinity_boots.get()) {
            poseStack.pushPose();
            ModelPart hat = this.bodyRoot.getChild("hat");
            float hue = (float)(System.currentTimeMillis() - AvaritiaForgeClient.lastTime) / 2000.0f;
            int rgb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb >> 0 & 0xFF) / 255.0f;
            hat.render(poseStack, multiBufferSource.getBuffer(AvaritiaRenderTypes.Glow(Res.EYE_TEX)), packedLight, packedOverlay, r, g, b, alpha);
            super.renderToBuffer(poseStack, Res.ARMOR_MASK_INV.wrap(multiBufferSource.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.popPose();
        }
    }

    public static Material material(ResourceLocation t) {
        return new Material(InventoryMenu.BLOCK_ATLAS, t);
    }
}

