/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model.loader;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.api.client.model.bakedmodels.WrappedItemModel;
import committee.nova.mods.avaritia.api.client.util.TransformUtils;
import committee.nova.mods.avaritia.client.AvaritiaForgeClient;
import committee.nova.mods.avaritia.client.model.entity.InfinityTridentModel;
import committee.nova.mods.avaritia.client.render.util.ArcRender;
import committee.nova.mods.avaritia.client.shader.AvaritiaRenderTypes;
import committee.nova.mods.avaritia.client.shader.AvaritiaShaders;
import committee.nova.mods.avaritia.init.registry.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class CosmicArcBakeModel
extends WrappedItemModel {
    private final List<ResourceLocation> maskSprite;

    public CosmicArcBakeModel(BakedModel wrapped, List<ResourceLocation> maskSprite) {
        super(wrapped);
        this.maskSprite = maskSprite;
        this.cosmic = true;
    }

    @Override
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, PoseStack pStack, MultiBufferSource source, int packedLight, int packedOverlay, ItemModelShaper itemModelShaper, TextureManager textureManager) {
        if (stack.is((Item)ModItems.infinity_trident.get())) {
            this.parentState = TransformUtils.DEFAULT_TRIDENT;
            if (transformType == ItemDisplayContext.GUI || transformType == ItemDisplayContext.GROUND || transformType == ItemDisplayContext.FIXED) {
                this.cosmic = true;
                this.renderWrapped(stack, pStack, source, packedLight, packedOverlay, true);
            } else {
                this.cosmic = false;
                InfinityTridentModel tridentModel = new InfinityTridentModel();
                pStack.pushPose();
                pStack.scale(1.0f, -1.0f, -1.0f);
                VertexConsumer vertexconsumer1 = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)tridentModel.renderType(Res.TRIDENT_TEX), (boolean)false, (boolean)stack.hasFoil());
                tridentModel.renderToBuffer(pStack, vertexconsumer1, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                pStack.popPose();
            }
        } else {
            this.parentState = TransformUtils.DEFAULT_ITEM;
            this.renderWrapped(stack, pStack, source, packedLight, packedOverlay, true);
        }
        if (source instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bs = (MultiBufferSource.BufferSource)source;
            bs.endBatch();
        }
        if (transformType != ItemDisplayContext.GUI && transformType != ItemDisplayContext.GROUND) {
            pStack.pushPose();
            float startX = 0.0f;
            float startY = -0.5f;
            float startZ = 0.0f;
            float endX = 0.0f;
            float endY = 0.0f;
            float endZ = 0.0f;
            long seed = System.currentTimeMillis();
            float thickness = 0.02f;
            int segments = 8;
            pStack.mulPose(Axis.YP.rotationDegrees((float)(System.currentTimeMillis() / 10L % 360L)));
            ArcRender.renderArc(pStack, source, seed, startX, startY, startZ, endX, endY, endZ, thickness, segments);
            pStack.popPose();
        }
        Minecraft mc = Minecraft.getInstance();
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 1.0f;
        if (AvaritiaForgeClient.inventoryRender || transformType == ItemDisplayContext.GUI) {
            scale = 100.0f;
            yaw = (float)((double)(mc.player.getYRot() * 2.0f) * Math.PI / 360.0);
            pitch = -((float)((double)(mc.player.getXRot() * 2.0f) * Math.PI / 360.0));
        }
        AvaritiaShaders.cosmicTime.set((float)(mc.level.getGameTime() % Integer.MAX_VALUE));
        AvaritiaShaders.cosmicYaw.set(yaw);
        AvaritiaShaders.cosmicPitch.set(pitch);
        AvaritiaShaders.cosmicExternalScale.set(scale);
        AvaritiaShaders.cosmicOpacity.set(1.0f);
        AvaritiaShaders.cosmicUVs.set(AvaritiaShaders.COSMIC_UVS);
        VertexConsumer cons = source.getBuffer(AvaritiaRenderTypes.COSMIC);
        ArrayList<TextureAtlasSprite> atlasSprite = new ArrayList<TextureAtlasSprite>();
        for (ResourceLocation res : this.maskSprite) {
            atlasSprite.add((TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(res));
        }
        mc.getItemRenderer().renderQuadList(pStack, cons, CosmicArcBakeModel.bakeItem(atlasSprite), stack, packedLight, packedOverlay);
    }
}

